/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.persistence;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.WaitNonBlockingStore;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.indexedembedded.City;
import org.infinispan.query.indexedembedded.Country;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.persistence.EntryActivatingTest")
public class EntryActivatingTest
extends AbstractInfinispanTest {
    Cache<String, Country> cache;
    WaitNonBlockingStore store;
    CacheContainer cm;
    QueryFactory queryFactory;
    SearchMapping searchMapping;

    @BeforeClass
    public void setUp() {
        this.recreateCacheManager();
    }

    @AfterClass
    public void tearDown() {
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{this.cm});
    }

    public void testPersistence() throws PersistenceException {
        this.verifyFullTextHasMatches(0);
        Country italy = new Country();
        italy.countryName = "Italy";
        City rome = new City();
        rome.name = "Rome";
        italy.cities.add(rome);
        this.cache.put((Object)"IT", (Object)italy);
        assert (!this.store.contains((Object)"IT"));
        this.verifyFullTextHasMatches(1);
        this.cache.evict((Object)"IT");
        assert (this.store.contains((Object)"IT"));
        InternalCacheEntry internalCacheEntry = this.cache.getAdvancedCache().getDataContainer().get((Object)"IT");
        assert (internalCacheEntry == null);
        this.verifyFullTextHasMatches(1);
        Country country = (Country)this.cache.get((Object)"IT");
        assert (country != null);
        assert ("Italy".equals(country.countryName));
        this.verifyFullTextHasMatches(1);
        this.cache.stop();
        assert (this.searchMapping.isClose());
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{this.cm});
        this.recreateCacheManager();
        this.verifyFullTextHasMatches(0);
    }

    private void recreateCacheManager() {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)cfg.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).preload(true)).indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(Country.class);
        this.cm = TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
        this.cache = this.cm.getCache();
        this.store = TestingUtil.getFirstStore(this.cache);
        this.queryFactory = Search.getQueryFactory(this.cache);
        this.searchMapping = (SearchMapping)TestingUtil.extractComponent(this.cache, SearchMapping.class);
    }

    private void verifyFullTextHasMatches(int i) {
        String query = String.format("FROM %s WHERE countryName:'Italy'", Country.class.getName());
        List list = this.queryFactory.create(query).list();
        AssertJUnit.assertEquals((int)i, (int)list.size());
    }
}

