/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.infinispan.Cache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.CustomKey3;
import org.infinispan.query.test.CustomKey3Transformer;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="query.blackbox.LocalCacheTest")
public class LocalCacheTest
extends SingleCacheManagerTest {
    protected Person person1;
    protected Person person2;
    protected Person person3;
    protected Person person4;
    protected AnotherGrassEater anotherGrassEater;
    protected String key1 = "Navin";
    protected String key2 = "BigGoat";
    protected String key3 = "MiniGoat";
    protected String anotherGrassEaterKey = "anotherGrassEaterKey";

    public LocalCacheTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    private <T> Query<T> createQuery(String predicate, Class<T> entity) {
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        return queryFactory.create(String.format("FROM %s WHERE %s", entity.getName(), predicate));
    }

    public void testSimple() {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        List found = cacheQuery.execute().list();
        int elems = found.size();
        assert (elems == 1) : "Expected 1 but was " + elems;
        Person val = (Person)found.get(0);
        assert (val.equals(this.person1)) : "Expected " + this.person1 + " but was " + val;
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testEagerIterator() {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        try (CloseableIterator found = cacheQuery.iterator();){
            AssertJUnit.assertTrue((boolean)found.hasNext());
            found.next();
            AssertJUnit.assertFalse((boolean)found.hasNext());
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testIteratorWithProjections() {
        this.loadTestingData();
        QueryFactory queryFactory = Search.getQueryFactory((Cache)this.cache);
        String q = String.format("SELECT name, blurb from %s p where name:'navin'", Person.class.getName());
        Query query = queryFactory.create(q);
        try (CloseableIterator found = query.iterator();){
            AssertJUnit.assertTrue((boolean)found.hasNext());
            Object[] next = (Object[])found.next();
            AssertJUnit.assertEquals((Object)"Navin Surtani", (Object)next[0]);
            AssertJUnit.assertEquals((Object)"Likes playing WoW", (Object)next[1]);
            AssertJUnit.assertFalse((boolean)found.hasNext());
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testEagerIteratorRemove() {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        try (CloseableIterator found = cacheQuery.iterator();){
            AssertJUnit.assertTrue((boolean)found.hasNext());
            found.remove();
        }
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testEagerIteratorExCase() {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        try (CloseableIterator found = cacheQuery.iterator();){
            AssertJUnit.assertTrue((boolean)found.hasNext());
            found.next();
            AssertJUnit.assertFalse((boolean)found.hasNext());
            found.next();
        }
    }

    public void testMultipleResults() {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("name:'goat'", Person.class);
        QueryResult result = cacheQuery.execute();
        List found = result.list();
        assert (found.size() == 2);
        AssertJUnit.assertEquals((long)2L, (long)this.getNumberOfHits(result));
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person3));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testModified() {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        List found = cacheQuery.execute().list();
        assert (found.size() == 1);
        assert (((Person)found.get(0)).equals(this.person1));
        this.person1.setBlurb("Likes pizza");
        this.cache.put((Object)this.key1, (Object)this.person1);
        cacheQuery = this.createQuery("blurb:'pizza'", Person.class);
        found = cacheQuery.execute().list();
        assert (found.size() == 1);
        assert (((Person)found.get(0)).equals(this.person1));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testAdded() {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("name:'Goat'", Person.class);
        QueryResult result = cacheQuery.execute();
        List found = result.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        AssertJUnit.assertEquals((long)2L, (long)this.getNumberOfHits(result));
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person3));
        AssertJUnit.assertFalse((boolean)found.contains(this.person4));
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.cache.put((Object)"mighty", (Object)this.person4);
        cacheQuery = this.createQuery("name:'Goat'", Person.class);
        found = cacheQuery.execute().list();
        assert (found.size() == 3) : "Size of list should be 3";
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testRemoved() {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("name:'Goat'", Person.class);
        QueryResult result = cacheQuery.execute();
        List found = result.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        AssertJUnit.assertEquals((long)2L, (long)this.getNumberOfHits(result));
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertTrue((boolean)found.contains(this.person3));
        this.cache.remove((Object)this.key3);
        cacheQuery = this.createQuery("name:'Goat'", Person.class);
        found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        AssertJUnit.assertFalse((boolean)found.contains(this.person3));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testUpdated() {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("name:'Goat'", Person.class);
        QueryResult result = cacheQuery.execute();
        List found = result.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        AssertJUnit.assertEquals((long)2L, (long)this.getNumberOfHits(result));
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        this.cache.put((Object)this.key2, (Object)this.person1);
        cacheQuery = this.createQuery("name:'Goat'", Person.class);
        result = cacheQuery.execute();
        found = result.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        AssertJUnit.assertEquals((long)1L, (long)this.getNumberOfHits(result));
        AssertJUnit.assertFalse((boolean)found.contains(this.person2));
        AssertJUnit.assertFalse((boolean)found.contains(this.person1));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testSetSort() {
        this.loadTestingData();
        String queryString = String.format("FROM %s p WHERE p.name:'Goat' ORDER BY p.age", Person.class.getName());
        Query cacheQuery = Search.getQueryFactory((Cache)this.cache).create(queryString);
        QueryResult result = cacheQuery.execute();
        List found = result.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        AssertJUnit.assertEquals((Object)this.person3, found.get(0));
        AssertJUnit.assertEquals((Object)this.person2, found.get(1));
        StaticTestingErrorHandler.assertAllGood(this.cache);
        this.person2.setAge(10);
        this.cache.put((Object)this.key2, (Object)this.person2);
        found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        AssertJUnit.assertEquals((Object)this.person2, found.get(0));
        AssertJUnit.assertEquals((Object)this.person3, found.get(1));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testSetFilter() {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("name:'goat'", Person.class);
        List found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        cacheQuery = this.createQuery("name:'goat' AND blurb:'cheese'", Person.class);
        found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testLazyIterator() {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        try (CloseableIterator found = cacheQuery.iterator();){
            AssertJUnit.assertTrue((boolean)found.hasNext());
            found.next();
            AssertJUnit.assertFalse((boolean)found.hasNext());
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testIteratorWithDefaultOptions() {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        try (CloseableIterator found = cacheQuery.iterator();){
            AssertJUnit.assertTrue((boolean)found.hasNext());
            found.next();
            AssertJUnit.assertFalse((boolean)found.hasNext());
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testIteratorRemove() {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("blurb:'Eats'", Person.class);
        try (CloseableIterator iterator = cacheQuery.iterator();){
            if (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testLazyIteratorWithOffset() {
        this.loadTestingData();
        Query cacheQuery = this.createQuery("blurb:'Eats'", Person.class).startOffset(1L);
        try (CloseableIterator iterator = cacheQuery.iterator();){
            AssertJUnit.assertEquals((int)1, (int)this.countElements((Iterator<?>)iterator));
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSearchManagerWithNullCache() {
        Search.getQueryFactory(null);
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testLazyIteratorWithNoElementsFound() {
        this.loadTestingData();
        Query cacheQuery = this.createQuery("blurb:'fish'", Person.class).startOffset(1L);
        try (CloseableIterator found = cacheQuery.iterator();){
            found.next();
        }
    }

    public void testSearchKeyTransformer() {
        this.loadTestingDataWithCustomKey();
        Query<Person> cacheQuery = this.createQuery("blurb:'Eats'", Person.class);
        try (CloseableIterator iterator = cacheQuery.iterator();){
            AssertJUnit.assertEquals((int)2, (int)this.countElements((Iterator<?>)iterator));
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSearchWithWrongCache() {
        Cache cache = (Cache)Mockito.mock(CacheImpl.class);
        Mockito.when((Object)cache.getAdvancedCache()).thenReturn(null);
        Search.getQueryFactory((Cache)cache);
    }

    public void testSearchManagerWithInstantiation() {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        try (CloseableIterator found = cacheQuery.iterator();){
            AssertJUnit.assertTrue((boolean)found.hasNext());
            found.next();
            AssertJUnit.assertFalse((boolean)found.hasNext());
        }
    }

    public void testGetResultSize() {
        this.loadTestingData();
        Query<Person> cacheQuery = this.createQuery("blurb:'playing'", Person.class);
        AssertJUnit.assertEquals((long)1L, (long)this.getNumberOfHits(cacheQuery.execute()));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testMaxResults() {
        this.loadTestingData();
        Query cacheQuery = this.createQuery("blurb:'eats'", Person.class).maxResults(1);
        QueryResult result = cacheQuery.execute();
        AssertJUnit.assertEquals((long)2L, (long)this.getNumberOfHits(result));
        AssertJUnit.assertEquals((int)1, (int)result.list().size());
        try (CloseableIterator eagerIterator = cacheQuery.iterator();){
            AssertJUnit.assertEquals((int)1, (int)this.countElements((Iterator<?>)eagerIterator));
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    private int countElements(Iterator<?> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public void testClear() {
        this.loadTestingData();
        String predicate = "name:'navin' OR name:'goat'";
        Query<Person> cacheQuery = this.createQuery(predicate, Person.class);
        AssertJUnit.assertEquals((long)3L, (long)this.getNumberOfHits(cacheQuery.execute()));
        this.cache.clear();
        cacheQuery = this.createQuery(predicate, Person.class);
        AssertJUnit.assertEquals((long)0L, (long)this.getNumberOfHits(cacheQuery.execute()));
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    public void testTypeFiltering() {
        this.loadTestingData();
        Object cacheQuery = this.createQuery("blurb:'grass'", Person.class);
        List found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        AssertJUnit.assertTrue((boolean)found.contains(this.person2));
        cacheQuery = this.createQuery("blurb:'grass'", AnotherGrassEater.class);
        found = cacheQuery.execute().list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
        AssertJUnit.assertEquals(found.get(0), (Object)this.anotherGrassEater);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addKeyTransformer(CustomKey3.class, CustomKey3Transformer.class).addIndexedEntity(Person.class).addIndexedEntity(AnotherGrassEater.class).addProperty("hibernate.search.background_failure_handler", StaticTestingErrorHandler.class.getName());
        this.enhanceConfig(cfg);
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)QueryTestSCI.INSTANCE, (ConfigurationBuilder)cfg);
    }

    protected void teardown() {
        if (this.cache != null) {
            this.cache.clear();
        }
        super.teardown();
    }

    protected void loadTestingData() {
        this.prepareTestingData();
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key3, (Object)this.person3);
        this.cache.put((Object)this.anotherGrassEaterKey, (Object)this.anotherGrassEater);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    protected void loadTestingDataWithCustomKey() {
        this.prepareTestingData();
        CustomKey3 customeKey1 = new CustomKey3(this.key1);
        CustomKey3 customeKey2 = new CustomKey3(this.key2);
        CustomKey3 customeKey3 = new CustomKey3(this.key3);
        this.cache.put((Object)customeKey1, (Object)this.person1);
        this.cache.put((Object)customeKey2, (Object)this.person2);
        this.cache.put((Object)customeKey2, (Object)this.person2);
        this.cache.put((Object)customeKey2, (Object)this.person2);
        this.cache.put((Object)customeKey3, (Object)this.person3);
        this.cache.put((Object)this.anotherGrassEaterKey, (Object)this.anotherGrassEater);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    private void prepareTestingData() {
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setAge(20);
        this.person1.setBlurb("Likes playing WoW");
        this.person1.setNonIndexedField("test1");
        this.person2 = new Person();
        this.person2.setName("Big Goat");
        this.person2.setAge(30);
        this.person2.setBlurb("Eats grass");
        this.person2.setNonIndexedField("test2");
        this.person3 = new Person();
        this.person3.setName("Mini Goat");
        this.person3.setAge(25);
        this.person3.setBlurb("Eats cheese");
        this.person3.setNonIndexedField("test3");
        this.anotherGrassEater = new AnotherGrassEater("Another grass-eater", "Eats grass");
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    protected void enhanceConfig(ConfigurationBuilder c) {
    }

    private long getNumberOfHits(QueryResult<?> queryResult) {
        return queryResult.hitCount().orElse(-1L);
    }
}

