/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.continuous;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.Search;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.api.continuous.ContinuousQueryListener;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="query.continuous.ContinuousQueryProfilingTest")
public class ContinuousQueryProfilingTest
extends MultipleCacheManagersTest {
    private static final int NUM_NODES = 10;
    private static final int NUM_OWNERS = 3;
    private static final int NUM_ENTRIES = 100000;
    private static final int NUM_LISTENERS = 1000;

    protected void createCacheManagers() {
        ConfigurationBuilder c = this.buildConfiguration();
        this.createCluster(QueryTestSCI.INSTANCE, c, 10);
        this.waitForClusterToForm();
    }

    private ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder c = ContinuousQueryProfilingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        c.clustering().hash().numOwners(3);
        return c;
    }

    public void testContinuousQueryPerformance() {
        long t1 = this.testContinuousQueryPerformance(false);
        long t2 = this.testContinuousQueryPerformance(true);
        this.log.infof("ContinuousQueryProfilingTest.testContinuousQueryPerformance doRegisterListener=false took %d us\n", (Object)(t1 / 1000L));
        this.log.infof("ContinuousQueryProfilingTest.testContinuousQueryPerformance doRegisterListener=true  took %d us\n", (Object)(t2 / 1000L));
    }

    private long testContinuousQueryPerformance(boolean doRegisterListener) {
        Cache cache;
        Person value;
        int i;
        ContinuousQuery cq = Search.getContinuousQuery((Cache)this.cache(0));
        if (doRegisterListener) {
            Query<Person> query = this.makeQuery(this.cache(0));
            for (int i2 = 0; i2 < 1000; ++i2) {
                cq.addContinuousQueryListener(query, (ContinuousQueryListener)new ContinuousQueryListener<String, Person>(){});
            }
        }
        long startTs = System.nanoTime();
        for (i = 0; i < 100000; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            cache = this.cache(i % 10);
            cache.put((Object)value.getName(), (Object)value);
        }
        for (i = 0; i < 100000; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            cache = this.cache(i % 10);
            cache.put((Object)value.getName(), (Object)value);
        }
        long endTs = System.nanoTime();
        cq.removeAllListeners();
        return endTs - startTs;
    }

    private Query<Person> makeQuery(Cache<?, ?> c) {
        QueryFactory qf = Search.getQueryFactory(c);
        return qf.create("FROM org.infinispan.query.test.Person WHERE age >= 18");
    }
}

