/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl.model;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.DocumentId;
import org.infinispan.query.dsl.embedded.impl.model.Company;

@Indexed
public class Employee {
    public String id;
    public String name;
    public long position;
    public Long code;
    public String text;
    public String title;
    public String otherInfo;
    public Company author;
    public List<ContactDetails> contactDetails = new ArrayList<ContactDetails>();
    public List<ContactDetails> alternativeContactDetails = new ArrayList<ContactDetails>();

    @DocumentId
    @Field(analyze=Analyze.NO, store=Store.YES)
    public String getId() {
        return this.id;
    }

    @Field(analyze=Analyze.NO, store=Store.YES)
    public String getName() {
        return this.name;
    }

    @SortableField
    @Field(analyze=Analyze.NO)
    public Long getPosition() {
        return this.position;
    }

    @SortableField
    @Field(indexNullAs="-1", analyze=Analyze.NO)
    public Long getCode() {
        return this.code;
    }

    @Field(store=Store.YES)
    public String getText() {
        return this.text;
    }

    @SortableField
    @Field(analyze=Analyze.NO)
    public String getTitle() {
        return this.title;
    }

    @Fields(value={@Field(name="analyzedInfo", analyze=Analyze.YES), @Field(name="someMoreInfo", analyze=Analyze.NO), @Field(name="sameInfo", analyze=Analyze.NO)})
    public String getOtherInfo() {
        return this.otherInfo;
    }

    @IndexedEmbedded
    public Company getAuthor() {
        return this.author;
    }

    @IndexedEmbedded
    public List<ContactDetails> getContactDetails() {
        return this.contactDetails;
    }

    @IndexedEmbedded
    public List<ContactDetails> getAlternativeContactDetails() {
        return this.alternativeContactDetails;
    }

    public static class ContactDetails {
        public String email;
        public String phoneNumber;
        public ContactAddress address;

        @Field(analyze=Analyze.NO, store=Store.YES)
        public String getEmail() {
            return this.email;
        }

        @Field(analyze=Analyze.NO)
        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        @IndexedEmbedded
        public ContactAddress getAddress() {
            return this.address;
        }

        public static class ContactAddress {
            public String address;
            public String postCode;
            public List<ContactAddress> alternatives = new ArrayList<ContactAddress>();

            @Field(analyze=Analyze.NO)
            public String getAddress() {
                return this.address;
            }

            @Field(analyze=Analyze.NO)
            public String getPostCode() {
                return this.postCode;
            }

            @IndexedEmbedded(depth=3)
            public List<ContactAddress> getAlternatives() {
                return this.alternatives;
            }
        }
    }
}

