/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.statetransfer;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.query.statetransfer.BaseReIndexingTest;
import org.infinispan.query.test.Person;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.statetransfer.PersistentStateTransferQueryIndexTest")
public class PersistentStateTransferQueryIndexTest
extends BaseReIndexingTest {
    @Override
    protected void configureCache(ConfigurationBuilder builder) {
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.clustering().stateTransfer().fetchInMemoryState(true).persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).shared(false)).preload(true)).fetchPersistentState(true);
    }

    public void testFetchingPersistentStateUpdatesIndex() throws Exception {
        this.loadCacheEntries((Cache<String, Person>)((Cache)this.caches().get(0)));
        Cache cache1 = (Cache)this.caches().get(0);
        this.executeSimpleQuery((Cache<String, Person>)cache1);
        this.checkCacheStoresEmpty();
        for (Cache cache : this.caches()) {
            for (Person p2 : this.persons) {
                cache.evict((Object)p2.getName());
            }
        }
        this.checkCacheStoresContainPersons();
        this.addNodeCheckingContentsAndQuery();
    }

    private void checkCacheStoresContainPersons() throws PersistenceException {
        for (Cache cache : this.caches()) {
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore((Cache)cache);
            for (int i = 0; i < this.persons.length; ++i) {
                AssertJUnit.assertEquals((Object)this.persons[i], (Object)store.loadEntry((Object)this.persons[i].getName()).getValue());
            }
        }
    }

    private void checkCacheStoresEmpty() throws PersistenceException {
        for (Cache cache : this.caches()) {
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore((Cache)cache);
            for (Person person : this.persons) {
                assert (!store.contains((Object)person.getName()));
            }
        }
    }
}

