/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.query.Search;
import org.infinispan.query.blackbox.ClusteredQueryTest;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.ClusteredQueryMultipleCachesTest")
public class ClusteredQueryMultipleCachesTest
extends ClusteredQueryTest {
    Cache<String, Person> cacheBMachine1;
    Cache<String, Person> cacheBMachine2;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = ClusteredQueryMultipleCachesTest.getDefaultClusteredCacheConfig((CacheMode)this.getCacheMode(), (boolean)false);
        cacheCfg.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(Person.class).addProperty("hibernate.search.background_failure_handler", StaticTestingErrorHandler.class.getName());
        this.createClusteredCaches(2, QueryTestSCI.INSTANCE, cacheCfg, new TransportFlags(), new String[]{"cacheA", "cacheB"});
        this.cacheAMachine1 = this.manager(0).getCache("cacheA");
        this.cacheAMachine2 = this.manager(1).getCache("cacheA");
        this.cacheBMachine1 = this.manager(0).getCache("cacheB");
        this.cacheBMachine2 = this.manager(1).getCache("cacheB");
        this.queryFactory1 = Search.getQueryFactory((Cache)this.cacheAMachine1);
        this.queryFactory2 = Search.getQueryFactory((Cache)this.cacheAMachine2);
        this.populateCache();
    }

    @Override
    protected void prepareTestData() {
        super.prepareTestData();
        Person person5 = new Person();
        person5.setName("People In Another Cache");
        person5.setBlurb("Also eats grass");
        person5.setAge(5);
        this.cacheBMachine2.put((Object)"anotherNewOne", (Object)person5);
    }
}

