/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.IOException;
import java.util.Map;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.config.QueryParsingTest")
public class QueryParsingTest
extends AbstractInfinispanTest {
    public void testConfigurationFileParsing() throws IOException {
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader());
        ConfigurationBuilderHolder holder = parserRegistry.parseFile("configuration-parsing-test.xml");
        Map namedConfigurations = holder.getNamedConfigurationBuilders();
        Configuration defaultConfiguration = ((ConfigurationBuilder)namedConfigurations.get("default")).build();
        Assert.assertEquals((int)defaultConfiguration.indexing().properties().size(), (int)0);
        Assert.assertFalse((boolean)defaultConfiguration.indexing().enabled());
        Configuration simpleCfg = ((ConfigurationBuilder)namedConfigurations.get("simple")).build();
        Assert.assertFalse((boolean)simpleCfg.indexing().enabled());
        Assert.assertEquals((int)simpleCfg.indexing().properties().size(), (int)0);
        Configuration memoryCfg = ((ConfigurationBuilder)namedConfigurations.get("memory-searchable")).build();
        Assert.assertTrue((boolean)memoryCfg.indexing().enabled());
        Assert.assertTrue((boolean)memoryCfg.indexing().properties().isEmpty());
        Assert.assertEquals((Object)IndexStorage.LOCAL_HEAP, (Object)memoryCfg.indexing().storage());
        Configuration diskCfg = ((ConfigurationBuilder)namedConfigurations.get("disk-searchable")).build();
        Assert.assertTrue((boolean)diskCfg.indexing().enabled());
        Assert.assertTrue((boolean)diskCfg.indexing().properties().isEmpty());
        Assert.assertEquals((Object)diskCfg.indexing().storage(), (Object)IndexStorage.FILESYSTEM);
        Assert.assertEquals((String)diskCfg.indexing().path(), (String)"target/");
        Configuration replDefaults = ((ConfigurationBuilder)namedConfigurations.get("repl-with-default")).build();
        Assert.assertTrue((boolean)replDefaults.indexing().enabled());
        Assert.assertFalse((boolean)replDefaults.indexing().properties().isEmpty());
    }

    public void testConfigurationFileParsingWithDefaultEnabled() throws IOException {
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader());
        ConfigurationBuilderHolder holder = parserRegistry.parseFile("configuration-parsing-test-enbledInDefault.xml");
        Map namedConfigurations = holder.getNamedConfigurationBuilders();
        Configuration defaultConfiguration = ((ConfigurationBuilder)namedConfigurations.get("default")).build();
        Assert.assertTrue((boolean)defaultConfiguration.indexing().properties().isEmpty());
        Assert.assertTrue((boolean)defaultConfiguration.indexing().enabled());
        Assert.assertEquals((Object)IndexStorage.LOCAL_HEAP, (Object)defaultConfiguration.indexing().storage());
        Configuration nonSearchableCfg = ((ConfigurationBuilder)namedConfigurations.get("not-searchable")).build();
        Assert.assertFalse((boolean)nonSearchableCfg.indexing().enabled());
        Configuration simpleCfg = ((ConfigurationBuilder)namedConfigurations.get("simple")).build();
        Assert.assertTrue((boolean)simpleCfg.indexing().enabled());
        Assert.assertTrue((boolean)simpleCfg.indexing().properties().isEmpty());
        Configuration memoryCfg = ((ConfigurationBuilder)namedConfigurations.get("memory-searchable")).build();
        Assert.assertTrue((boolean)memoryCfg.indexing().enabled());
        Assert.assertTrue((boolean)memoryCfg.indexing().properties().isEmpty());
        Assert.assertEquals((Object)memoryCfg.indexing().storage(), (Object)IndexStorage.LOCAL_HEAP);
        Configuration diskCfg = ((ConfigurationBuilder)namedConfigurations.get("disk-searchable")).build();
        Assert.assertTrue((boolean)diskCfg.indexing().enabled());
        Assert.assertTrue((boolean)diskCfg.indexing().properties().isEmpty());
        Assert.assertEquals((Object)diskCfg.indexing().storage(), (Object)IndexStorage.FILESYSTEM);
        Assert.assertEquals((String)diskCfg.indexing().path(), (String)"target/");
    }
}

