/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.query.Search;
import org.infinispan.query.blackbox.ClusteredQueryTest;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.DistributedCacheClusteredQueryTest")
public class DistributedCacheClusteredQueryTest
extends ClusteredQueryTest {
    @Override
    public CacheMode getCacheMode() {
        return CacheMode.DIST_SYNC;
    }

    @Override
    protected int numOwners() {
        return 1;
    }

    @Test
    public void testIndexedQueryLocalOnly() {
        QueryFactory queryFactoryA = Search.getQueryFactory((Cache)this.cache(0));
        QueryFactory queryFactoryB = Search.getQueryFactory((Cache)this.cache(1));
        Query normalQueryA = queryFactoryA.create(this.queryString);
        Query normalQueryB = queryFactoryB.create(this.queryString);
        AssertJUnit.assertEquals((long)10L, (long)normalQueryA.execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)10L, (long)normalQueryB.execute().hitCount().orElse(-1L));
        List results1 = normalQueryA.local(true).execute().list();
        List results2 = normalQueryB.local(true).execute().list();
        AssertJUnit.assertEquals((int)10, (int)(results1.size() + results2.size()));
    }

    @Test
    public void testNonIndexedQueryLocalOnly() {
        String q = "FROM org.infinispan.query.test.Person p where p.nonIndexedField = 'na'";
        QueryFactory queryFactoryA = Search.getQueryFactory((Cache)this.cache(0));
        QueryFactory queryFactoryB = Search.getQueryFactory((Cache)this.cache(1));
        List results1 = queryFactoryA.create(q).local(true).execute().list();
        List results2 = queryFactoryB.create(q).local(true).execute().list();
        AssertJUnit.assertEquals((int)50, (int)(results1.size() + results2.size()));
        q = "SELECT COUNT(nonIndexedField) FROM org.infinispan.query.test.Person GROUP BY nonIndexedField";
        results1 = queryFactoryA.create(q).local(true).execute().list();
        results2 = queryFactoryB.create(q).local(true).execute().list();
        Object[] row1 = (Object[])results1.get(0);
        Object[] row2 = (Object[])results2.get(0);
        AssertJUnit.assertEquals((long)50L, (long)((Long)row1[0] + (Long)row2[0]));
    }
}

