/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.continuous;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.query.api.continuous.ContinuousQueryListener;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CallCountingCQResultListener<K, V>
implements ContinuousQueryListener<K, V> {
    private static final Log log = LogFactory.getLog(CallCountingCQResultListener.class);
    private final Map<K, Integer> joined = Collections.synchronizedMap(new HashMap());
    private final Map<K, Integer> updated = Collections.synchronizedMap(new HashMap());
    private final Map<K, Integer> left = Collections.synchronizedMap(new HashMap());

    public void resultJoining(K key, V value) {
        log.debugf("Key %s joined", key);
        this.incrementNumberOfCalls(key, this.joined);
    }

    public void resultUpdated(K key, V value) {
        log.debugf("Key %s updated", key);
        this.incrementNumberOfCalls(key, this.updated);
    }

    public void resultLeaving(K key) {
        log.debugf("Key %s left", key);
        this.incrementNumberOfCalls(key, this.left);
    }

    public Map<K, Integer> getJoined() {
        return this.joined;
    }

    public Map<K, Integer> getUpdated() {
        return this.updated;
    }

    public Map<K, Integer> getLeft() {
        return this.left;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementNumberOfCalls(K key, Map<K, Integer> callMap) {
        Map<K, Integer> map = callMap;
        synchronized (map) {
            Integer calls = callMap.get(key);
            callMap.put(key, calls == null ? 1 : calls + 1);
        }
    }
}

