/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Indexer;
import org.infinispan.query.Search;
import org.infinispan.query.core.stats.IndexInfo;
import org.infinispan.query.core.stats.SearchStatistics;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.LocalFlagMassIndexingTest")
public class LocalMassIndexingTest
extends MultipleCacheManagersTest {
    protected static final int NUM_NODES = 3;
    private static final int ENTRIES = 50;

    protected String getConfigurationFile() {
        return "dynamic-indexing-distribution.xml";
    }

    protected void createCacheManagers() throws Throwable {
        for (int i2 = 0; i2 < 3; ++i2) {
            EmbeddedCacheManager cacheManager = TestCacheManagerFactory.fromXml((String)this.getConfigurationFile());
            this.registerCacheManager(new CacheContainer[]{cacheManager});
            cacheManager.getCache();
        }
        this.waitForClusterToForm();
        Cache cache = this.cache(0);
        IntStream.range(0, 50).forEach(i -> cache.put((Object)i, (Object)new Car("brand", "color", 100)));
    }

    public void testReindexing() throws Exception {
        Indexer indexer0 = Search.getIndexer((Cache)this.cache(0));
        Indexer indexer1 = Search.getIndexer((Cache)this.cache(1));
        Indexer indexer2 = Search.getIndexer((Cache)this.cache(2));
        CompletionStages.join((CompletionStage)indexer0.run());
        this.assertAllIndexed();
        this.clearIndexes();
        CompletionStages.join((CompletionStage)indexer0.runLocal());
        this.assertOnlyIndexed(0);
        this.clearIndexes();
        CompletionStages.join((CompletionStage)indexer1.runLocal());
        this.assertOnlyIndexed(1);
        this.clearIndexes();
        CompletionStages.join((CompletionStage)indexer2.runLocal());
        this.assertOnlyIndexed(2);
    }

    void clearIndexes() {
        CompletionStages.join((CompletionStage)Search.getIndexer((Cache)this.cache(0)).remove());
    }

    private void assertIndexState(BiConsumer<IndexInfo, Integer> cacheIndexInfo) {
        IntStream.range(0, 3).forEach(i -> {
            Cache cache = this.cache(i);
            SearchStatistics searchStatistics = Search.getSearchStatistics((Cache)cache);
            Map indexInfo = (Map)CompletionStages.join((CompletionStage)searchStatistics.getIndexStatistics().computeIndexInfos());
            cacheIndexInfo.accept((IndexInfo)indexInfo.get(Car.class.getName()), i);
        });
    }

    private void assertAllIndexed() {
        this.assertIndexState((indexInfo, i) -> Assert.assertTrue((indexInfo.count() > 0L ? 1 : 0) != 0));
    }

    private void assertOnlyIndexed(int id) {
        this.assertIndexState((indexInfo, i) -> {
            long count = indexInfo.count();
            if (i == id) {
                Assert.assertTrue((count > 0L ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((long)count, (long)0L);
            }
        });
    }
}

