/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.Collection;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.context.Flag;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.query.Indexer;
import org.infinispan.query.Search;
import org.infinispan.query.api.NotIndexedType;
import org.infinispan.query.distributed.DistributedMassIndexingTest;
import org.infinispan.query.impl.massindex.IndexUpdater;
import org.infinispan.query.impl.massindex.MassIndexerAlreadyStartedException;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.CompletionStages;
import org.junit.Assert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.MassIndexingTest")
public class MassIndexingTest
extends DistributedMassIndexingTest {
    @Override
    public void testReindexing() {
        for (int i = 0; i < 10; ++i) {
            this.cache(i % 2).getAdvancedCache().withFlags(Flag.SKIP_INDEXING).put(this.key("F" + i + "NUM"), (Object)new Car(i % 2 == 0 ? "megane" : "bmw", "blue", 300 + i));
        }
        this.cache(0).getAdvancedCache().put(this.key("FNonIndexed1NUM"), (Object)new NotIndexedType("test1"));
        this.cache(0).getAdvancedCache().put(this.key("FNonIndexed2NUM"), (Object)new NotIndexedType("test2"));
        this.verifyFindsCar(0, "megane");
        this.verifyFindsCar(0, "test1");
        this.verifyFindsCar(0, "test2");
        this.cache(0).getAdvancedCache().withFlags(Flag.SKIP_INDEXING).put(this.key("FNonIndexed3NUM"), (Object)new NotIndexedType("test3"));
        this.verifyFindsCar(0, "test3");
        this.rebuildIndexes();
        this.verifyFindsCar(5, "megane");
        this.verifyFindsCar(0, "test1");
        this.verifyFindsCar(0, "test2");
    }

    @Test
    public void testOverlappingMassIndexers() {
        Cache cache = this.cache(0);
        IntStream.range(0, 10).forEach(i -> cache.put((Object)i, (Object)new Car("whatever", "whatever", 0)));
        Indexer massIndexer = Search.getIndexer((Cache)cache);
        CountDownLatch latch = new CountDownLatch(1);
        this.instrumentIndexer(massIndexer, latch);
        CompletionStage first = massIndexer.run();
        CompletionStage second = massIndexer.run();
        latch.countDown();
        Assert.assertTrue((this.isSuccess(second) && this.isError(first) || this.isSuccess(first) && this.isError(second) ? 1 : 0) != 0);
        org.testng.Assert.assertFalse((boolean)massIndexer.isRunning());
        CompletionStage third = massIndexer.run();
        Assert.assertTrue((boolean)this.isSuccess(third));
    }

    private void instrumentIndexer(Indexer original, CountDownLatch latch) {
        TestingUtil.replaceField((Object)original, (String)"indexUpdater", indexUpdater -> {
            IndexUpdater mock = (IndexUpdater)Mockito.spy((Object)indexUpdater);
            ((IndexUpdater)Mockito.doAnswer(invocation -> {
                latch.await();
                return invocation.callRealMethod();
            }).when((Object)mock)).flush((Collection)ArgumentMatchers.any());
            return mock;
        });
    }

    public boolean isSuccess(CompletionStage<Void> future) {
        try {
            FunctionalTestUtils.await(future);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean isError(CompletionStage<Void> future) {
        try {
            FunctionalTestUtils.await(future);
            return false;
        }
        catch (Throwable e) {
            return Util.getRootCause((Throwable)e).getClass().equals(MassIndexerAlreadyStartedException.class);
        }
    }

    @Override
    protected void rebuildIndexes() {
        Cache cache = this.cache(0);
        CompletionStages.join((CompletionStage)Search.getIndexer((Cache)cache).run());
    }
}

