/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.List;
import java.util.Random;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.query.core.impl.QueryCache;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.AbstractQueryDslTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="query.dsl.embedded.NamedParamsPerfTest")
public class NamedParamsPerfTest
extends AbstractQueryDslTest {
    private static final int ITERATIONS = 1000;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(Person.class);
        this.createClusteredCaches(1, cfg);
    }

    public void testNamedParamPerfComparison() {
        QueryFactory factory = this.getQueryFactory();
        String[] fnames = new String[]{"Matej", "Roman", "Jakub", "Jiri", "Anna", "Martin", "Vojta", "Alan"};
        String[] lnames = new String[]{"Cimbora", "Macor", "Markos", "Holusa", "Manukyan", "Gencur", "Vrabel", "Juranek", "Field"};
        Random random = new Random(3L);
        for (int i = 0; i < 999; ++i) {
            this.cache(0).put((Object)i, (Object)new Person(i, fnames[random.nextInt(fnames.length)], lnames[random.nextInt(lnames.length)]));
        }
        this.cache(0).put((Object)1000, (Object)new Person(999, "Unnamed", "Unnamed"));
        QueryCache queryCache = (QueryCache)this.manager(0).getGlobalComponentRegistry().getComponent(QueryCache.class);
        AssertJUnit.assertNotNull((Object)queryCache);
        Query query = factory.create("FROM " + Person.class.getName() + " WHERE firstName = :nameParam1 OR lastName = :nameParam2 OR id >= :idParam1 OR id < :idParam2");
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        for (int i = 0; i < 1000; ++i) {
            queryCache.clear();
            long start = System.nanoTime();
            query.setParameter("nameParam1", (Object)"Unnamed").setParameter("nameParam2", (Object)"ww").setParameter("idParam1", (Object)1000).setParameter("idParam2", (Object)0);
            List list = query.execute().list();
            t1 += System.nanoTime() - start;
            AssertJUnit.assertEquals((int)1, (int)list.size());
            start = System.nanoTime();
            query.setParameter("nameParam1", (Object)"Unnamed").setParameter("nameParam2", (Object)"zz").setParameter("idParam1", (Object)2000).setParameter("idParam2", (Object)-1000);
            list = query.execute().list();
            t2 += System.nanoTime() - start;
            AssertJUnit.assertEquals((int)1, (int)list.size());
            start = System.nanoTime();
            query.setParameter("nameParam1", (Object)"Unnamed").setParameter("nameParam2", (Object)"bb").setParameter("idParam1", (Object)5000).setParameter("idParam2", (Object)-3000);
            list = query.execute().list();
            t3 += System.nanoTime() - start;
            AssertJUnit.assertEquals((int)1, (int)list.size());
        }
        System.out.println("NamedParamsPerfTest.testNamedParamPerfComparison t1 (avg, us) = " + (double)t1 / 1000.0 / 1000.0);
        System.out.println("NamedParamsPerfTest.testNamedParamPerfComparison t2 (avg, us) = " + (double)t2 / 1000.0 / 1000.0);
        System.out.println("NamedParamsPerfTest.testNamedParamPerfComparison t3 (avg, us) = " + (double)t3 / 1000.0 / 1000.0);
    }

    @Indexed
    static class Person {
        @Field(store=Store.YES, analyze=Analyze.NO)
        @SortableField
        final int id;
        @Field(store=Store.YES, analyze=Analyze.NO, indexNullAs="_null_")
        @SortableField
        final String firstName;
        @Field(store=Store.YES, analyze=Analyze.NO, indexNullAs="_null_")
        @SortableField
        final String lastName;

        Person(int id, String firstName, String lastName) {
            this.id = id;
            this.firstName = firstName;
            this.lastName = lastName;
        }
    }
}

