/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.assertj.core.api.Assertions;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.util.common.SearchException;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParser;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.syntax.parser.ReflectionEntityNamesResolver;
import org.infinispan.query.dsl.embedded.impl.HibernateSearchPropertyHelper;
import org.infinispan.query.dsl.embedded.impl.SearchQueryMaker;
import org.infinispan.query.dsl.embedded.impl.model.Employee;
import org.infinispan.query.helper.IndexAccessor;
import org.infinispan.query.helper.SearchMappingHelper;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LuceneTransformationTest {
    private SearchMapping searchMapping;
    private HibernateSearchPropertyHelper propertyHelper;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void initMapping() {
        this.searchMapping = SearchMappingHelper.createSearchMappingForTests(Employee.class);
        this.propertyHelper = new HibernateSearchPropertyHelper(this.searchMapping, (EntityNameResolver)new ReflectionEntityNamesResolver(null));
    }

    @After
    public void disposeMapping() {
        if (this.searchMapping != null) {
            this.searchMapping.close();
        }
    }

    @Test
    public void testRaiseExceptionDueToUnknownAlias() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028502: Unknown alias: a.");
        this.parseAndTransform("from org.infinispan.query.dsl.embedded.impl.model.Employee e where a.name = 'same'");
    }

    @Test
    public void testMatchAllQuery() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee", "+*:*");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e", "+*:*");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e", "+*:*");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where true", "+*:*");
    }

    @Test
    public void testRejectAllQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where false", "+(-*:* #*:*)");
    }

    @Test
    public void testFullTextKeyword() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : 'bicycle'", "+text:bicycle");
    }

    @Test
    public void testFullTextWildcard() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : 'geo*e'", "+text:geo*e");
    }

    @Test
    public void testFullTextFuzzy() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : 'jonh'~2", "+text:jonh~2");
    }

    @Test
    public void testFullTextPhrase() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : 'twisted cables'", "+text:\"twisted cables\"");
    }

    @Test
    public void testFullTextRegexp() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : /te?t/", "+text:/te?t/");
    }

    @Test
    public void testFullTextRegexp_boosted() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : /te?t/^3", "+(text:/te?t/)^3.0");
    }

    @Test
    public void testFullTextRange() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : ['AAA' 'ZZZ']", "+text:[aaa TO zzz]");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : ['AAA' to 'ZZZ']", "+text:[aaa TO zzz]");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : [* to 'eeee']", "+text:[* TO eeee]");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : ['eeee' to *]", "+text:[eeee TO *]");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : [* *]", "+ConstantScore(NormsFieldExistsQuery [field=text])");
    }

    @Test
    public void testFullTextFieldBoost() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : 'foo'^3.0'", "+(text:foo)^3.0");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : ('foo')^3.0'", "+(text:foo)^3.0");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : ('foo' and 'bar')^3.0'", "+(+text:foo +text:bar)^3.0");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : 'foo'^3.0 || e.analyzedInfo : 'bar'", "+((text:foo)^3.0 analyzedInfo:bar)");
    }

    @Test
    public void testFullTextFieldOccur() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : (-'foo') ", "+(-text:foo #*:*)");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : (-'foo' +'bar')", "+((-text:foo #*:*) (+text:bar))");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where not e.text : (-'foo' +'bar')", "+(-((-text:foo #*:*) (+text:bar)) #*:*)");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text : (-'foo' '*')", "+((-text:foo #*:*) *:*)");
    }

    @Test
    public void testRestrictedQueryUsingSelect() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' or e.id = 5", "+(name:same id:5)");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' and e.id = 5", "+(+name:same +id:5)");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' and not e.id = 5", "+(+name:same +(-id:5 #*:*))");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' or not e.id = 5", "+(name:same (-id:5 #*:*))");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where not e.id = 5", "+(-id:5 #*:*)");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.id != 5", "+(-id:5 #*:*)");
    }

    @Test
    public void testFieldMapping() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.someMoreInfo = 'foo'", "+someMoreInfo:foo");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.sameInfo = 'foo'", "+sameInfo:foo");
    }

    @Test
    public void testWrongFieldName() {
        this.expectedException.expect(SearchException.class);
        this.expectedException.expectMessage("HSEARCH600000: Unknown field 'otherInfo'.\nContext: indexes [org.infinispan.query.dsl.embedded.impl.model.Employee]");
        this.parseAndTransform("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.otherInfo = 'foo'");
    }

    @Test
    public void testProjectionQuery() {
        String ickle = "select e.id, e.name from org.infinispan.query.dsl.embedded.impl.model.Employee e";
        IckleParsingResult<Class<?>> parsed = this.parse(ickle);
        SearchQuery<?> query = this.transform(parsed);
        Assertions.assertThat((String)query.queryString()).isEqualTo((Object)"+*:*");
        Assertions.assertThat((Object[])parsed.getProjections()).isEqualTo((Object)new String[]{"id", "name"});
    }

    @Test
    public void testEmbeddedProjectionQuery() {
        String ickle = "select e.author.name from org.infinispan.query.dsl.embedded.impl.model.Employee e";
        IckleParsingResult<Class<?>> parsed = this.parse(ickle);
        SearchQuery<?> query = this.transform(parsed);
        Assertions.assertThat((String)query.queryString()).isEqualTo((Object)"+*:*");
        Assertions.assertThat((Object[])parsed.getProjections()).isEqualTo((Object)new String[]{"author.name"});
    }

    @Test
    public void testNestedEmbeddedProjectionQuery() {
        String ickle = "select e.author.address.street from org.infinispan.query.dsl.embedded.impl.model.Employee e";
        IckleParsingResult<Class<?>> parsed = this.parse(ickle);
        SearchQuery<?> query = this.transform(parsed);
        Assertions.assertThat((String)query.queryString()).isEqualTo((Object)"+*:*");
        Assertions.assertThat((Object[])parsed.getProjections()).isEqualTo((Object)new String[]{"author.address.street"});
    }

    @Test
    public void testQueryWithUnqualifiedPropertyReferences() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where name = 'same' and not id = 5", "+(+name:same +(-id:5 #*:*))");
    }

    @Test
    public void testNegatedQuery() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where NOT e.name = 'same'", "+(-name:same #*:*)");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name <> 'same'", "+(-name:same #*:*)");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name != 'same'", "+(-name:same #*:*)");
    }

    @Test
    public void testNegatedQueryOnNumericProperty() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position <> 3", "+(-position:[3 TO 3] #*:*)");
    }

    @Test
    public void testNegatedRangeQuery() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee where name = 'Bob' and not position between 1 and 3", "+(+name:Bob +(-position:[1 TO 3] #*:*))");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'Bob' and not e.position between 1 and 3", "+(+name:Bob +(-position:[1 TO 3] #*:*))");
    }

    @Test
    public void testQueryWithNamedParameter() {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("nameParameter", "Bob");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee where name = :nameParameter", namedParameters, "+name:Bob");
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = :nameParameter", namedParameters, "+name:Bob");
    }

    @Test
    public void testBooleanQuery() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' or (e.id = 4 and e.name = 'Bob')", "+(name:same (+id:4 +name:Bob))");
    }

    @Test
    public void testBooleanQueryUsingSelect() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' or (e.id = 4 and e.name = 'Bob')", "+(name:same (+id:4 +name:Bob))");
    }

    @Test
    public void testBetweenQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name between 'aaa' and 'zzz'", "+name:[aaa TO zzz]");
    }

    @Test
    public void testNotBetweenQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name not between 'aaa' and 'zzz'", "+(-name:[aaa TO zzz] #*:*)");
    }

    @Test
    public void testNumericNotBetweenQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where not e.position between 1 and 3", "+(-position:[1 TO 3] #*:*)");
    }

    @Test
    public void testBetweenQueryForCharacterLiterals() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name between 'a' and 'z'", "+name:[a TO z]");
    }

    @Test
    public void testBetweenQueryWithNamedParameters() {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("p1", "aaa");
        namedParameters.put("p2", "zzz");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name between :p1 and :p2", namedParameters, "+name:[aaa TO zzz]");
    }

    @Test
    public void testNumericBetweenQuery() {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("p1", 10L);
        namedParameters.put("p2", 20L);
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position between :p1 and :p2", namedParameters, "+position:[10 TO 20]");
    }

    @Test
    public void testQueryWithEmbeddedPropertyInFromClause() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.author.name = 'Bob'", "+author.name:Bob");
    }

    @Test
    public void testLessThanQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position < 100", "+position:[-9223372036854775808 TO 99]");
    }

    @Test
    public void testLessThanOrEqualsToQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position <= 100", "+position:[-9223372036854775808 TO 100]");
    }

    @Test
    public void testGreaterThanOrEqualsToQuery() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee where position >= 100", "+position:[100 TO 9223372036854775807]");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position >= 100", "+position:[100 TO 9223372036854775807]");
    }

    @Test
    public void testGreaterThanQuery() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee where position > 100", "+position:[101 TO 9223372036854775807]");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position > 100", "+position:[101 TO 9223372036854775807]");
    }

    @Test
    public void testInQuery() {
        this.assertGeneratedLuceneQuery("from org.infinispan.query.dsl.embedded.impl.model.Employee where name in ('Bob', 'Alice')", "+(name:Bob name:Alice)");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name in ('Bob', 'Alice')", "+(name:Bob name:Alice)");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position in (10, 20, 30, 40)", "+(position:[10 TO 10] position:[20 TO 20] position:[30 TO 30] position:[40 TO 40])");
    }

    @Test
    public void testInQueryWithNamedParameters() {
        HashMap<String, Object> namedParameters = new HashMap<String, Object>();
        namedParameters.put("name1", "Bob");
        namedParameters.put("name2", "Alice");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name in (:name1, :name2)", namedParameters, "+(name:Bob name:Alice)");
        namedParameters = new HashMap();
        namedParameters.put("pos1", 10);
        namedParameters.put("pos2", 20);
        namedParameters.put("pos3", 30);
        namedParameters.put("pos4", 40);
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position in (:pos1, :pos2, :pos3, :pos4)", namedParameters, "+(position:[10 TO 10] position:[20 TO 20] position:[30 TO 30] position:[40 TO 40])");
    }

    @Test
    public void testNotInQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name not in ('Bob', 'Alice')", "+(-(name:Bob name:Alice) #*:*)");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.position not in (10, 20, 30, 40)", "+(-(position:[10 TO 10] position:[20 TO 20] position:[30 TO 30] position:[40 TO 40]) #*:*)");
    }

    @Test
    public void testLikeQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name LIKE 'Al_ce'", "+name:Al?ce");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name LIKE 'Ali%'", "+name:Ali*");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name LIKE 'Ali%%'", "+name:Ali**");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name LIKE '_l_ce'", "+name:?l?ce");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name LIKE '___ce'", "+name:???ce");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name LIKE '_%_ce'", "+name:?*?ce");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name LIKE 'Alice in wonderl%'", "+name:Alice in wonderl*");
    }

    @Test
    public void testNotLikeQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name NOT LIKE 'Al_ce'", "+(-name:Al?ce #*:*)");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name NOT LIKE 'Ali%'", "+(-name:Ali* #*:*)");
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name NOT LIKE '_l_ce' and not (e.title LIKE '%goo' and e.position = '5')", "+(+(-name:?l?ce #*:*) +(-(+title:*goo +position:[5 TO 5]) #*:*))");
    }

    @Test
    public void testIsNullQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name IS null", "+(-ConstantScore(NormsFieldExistsQuery [field=name]) #*:*)");
    }

    @Test
    public void testIsNullQueryForEmbeddedEntity() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.author IS null", "+(-((ConstantScore(NormsFieldExistsQuery [field=author.address.city]) ConstantScore(NormsFieldExistsQuery [field=author.address.street]) __HSEARCH_field_names:author.address) ConstantScore(NormsFieldExistsQuery [field=author.name]) __HSEARCH_field_names:author) #*:*)");
    }

    @Test
    public void testIsNotNullQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name IS NOT null", "+ConstantScore(NormsFieldExistsQuery [field=name])");
    }

    @Test
    public void testCollectionOfEmbeddableQuery() {
        this.assertGeneratedLuceneQuery("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d WHERE d.email = 'ninja647@mailinator.com' ", "+contactDetails.email:ninja647@mailinator.com");
    }

    @Test
    public void testCollectionOfEmbeddableInEmbeddedQuery() {
        this.assertGeneratedLuceneQuery("SELECT e FROM org.infinispan.query.dsl.embedded.impl.model.Employee e  JOIN e.contactDetails d JOIN d.address.alternatives as a WHERE a.postCode = '90210' ", "+contactDetails.address.alternatives.postCode:90210");
    }

    @Test
    public void testRaiseExceptionDueToUnknownQualifiedProperty() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028501: The type org.infinispan.query.dsl.embedded.impl.model.Employee does not have an accessible property named 'foobar'.");
        this.parseAndTransform("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.foobar = 'same'");
    }

    @Test
    public void testRaiseExceptionDueToUnknownUnqualifiedProperty() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028501: The type org.infinispan.query.dsl.embedded.impl.model.Employee does not have an accessible property named 'foobar'.");
        this.parseAndTransform("from org.infinispan.query.dsl.embedded.impl.model.Employee e where foobar = 'same'");
    }

    @Test
    public void testRaiseExceptionDueToAnalyzedPropertyInFromClause() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028522: No relational queries can be applied to property 'text' in type org.infinispan.query.dsl.embedded.impl.model.Employee since the property is analyzed.");
        this.parseAndTransform("from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.text = 'foo'");
    }

    @Test
    public void testRaiseExceptionDueToUnknownPropertyInSelectClause() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028501: The type org.infinispan.query.dsl.embedded.impl.model.Employee does not have an accessible property named 'foobar'.");
        this.parseAndTransform("select e.foobar from org.infinispan.query.dsl.embedded.impl.model.Employee e");
    }

    @Test
    public void testRaiseExceptionDueToUnknownPropertyInEmbeddedSelectClause() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028501: The type org.infinispan.query.dsl.embedded.impl.model.Employee does not have an accessible property named 'foo'.");
        this.parseAndTransform("select e.author.foo from org.infinispan.query.dsl.embedded.impl.model.Employee e");
    }

    @Test
    public void testRaiseExceptionDueToSelectionOfCompleteEmbeddedEntity() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028503: Property author can not be selected from type org.infinispan.query.dsl.embedded.impl.model.Employee since it is an embedded entity.");
        this.parseAndTransform("select e.author from org.infinispan.query.dsl.embedded.impl.model.Employee e");
    }

    @Test
    public void testRaiseExceptionDueToUnqualifiedSelectionOfCompleteEmbeddedEntity() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028503: Property author can not be selected from type org.infinispan.query.dsl.embedded.impl.model.Employee since it is an embedded entity.");
        this.parseAndTransform("select author from org.infinispan.query.dsl.embedded.impl.model.Employee e");
    }

    @Test
    public void testDetermineTargetEntityType() {
        IckleParsingResult<Class<?>> parsed = this.parse("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' and not e.id = 5");
        Assertions.assertThat((Class)((Class)parsed.getTargetEntityMetadata())).isSameAs(Employee.class);
        Assertions.assertThat((String)parsed.getTargetEntityName()).isEqualTo((Object)"org.infinispan.query.dsl.embedded.impl.model.Employee");
        parsed = this.parse("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e");
        Assertions.assertThat((Class)((Class)parsed.getTargetEntityMetadata())).isSameAs(Employee.class);
        Assertions.assertThat((String)parsed.getTargetEntityName()).isEqualTo((Object)"org.infinispan.query.dsl.embedded.impl.model.Employee");
    }

    @Test
    public void testBuildOneFieldSort() {
        SearchQuery<?> result = this.parseAndTransform("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' order by e.title");
        Sort sort = IndexAccessor.extractSort(result);
        Assertions.assertThat((Object)sort).isNotNull();
        Assertions.assertThat((int)sort.getSort().length).isEqualTo(1);
        Assertions.assertThat((String)sort.getSort()[0].getField()).isEqualTo((Object)"title");
        Assertions.assertThat((boolean)sort.getSort()[0].getReverse()).isEqualTo(false);
        Assertions.assertThat((Comparable)sort.getSort()[0].getType()).isEqualTo((Object)SortField.Type.CUSTOM);
    }

    @Test
    public void testBuildTwoFieldsSort() {
        SearchQuery<?> result = this.parseAndTransform("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' order by e.title, e.position DESC");
        Sort sort = IndexAccessor.extractSort(result);
        Assertions.assertThat((Object)sort).isNotNull();
        Assertions.assertThat((int)sort.getSort().length).isEqualTo(2);
        Assertions.assertThat((String)sort.getSort()[0].getField()).isEqualTo((Object)"title");
        Assertions.assertThat((boolean)sort.getSort()[0].getReverse()).isEqualTo(false);
        Assertions.assertThat((Comparable)sort.getSort()[0].getType()).isEqualTo((Object)SortField.Type.CUSTOM);
        Assertions.assertThat((String)sort.getSort()[1].getField()).isEqualTo((Object)"position");
        Assertions.assertThat((boolean)sort.getSort()[1].getReverse()).isEqualTo(true);
        Assertions.assertThat((Comparable)sort.getSort()[1].getType()).isEqualTo((Object)SortField.Type.CUSTOM);
    }

    @Test
    public void testBuildSortForNullEncoding() {
        SearchQuery<?> result = this.parseAndTransform("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e order by e.code DESC");
        Sort sort = IndexAccessor.extractSort(result);
        Assertions.assertThat((Object)sort).isNotNull();
        Assertions.assertThat((int)sort.getSort().length).isEqualTo(1);
        Assertions.assertThat((String)sort.getSort()[0].getField()).isEqualTo((Object)"code");
        Assertions.assertThat((Comparable)sort.getSort()[0].getType()).isEqualTo((Object)SortField.Type.CUSTOM);
    }

    @Test
    public void testRaiseExceptionDueToUnrecognizedSortDirection() {
        this.expectedException.expect(ParsingException.class);
        this.expectedException.expectMessage("ISPN028526: Invalid query: select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' order by e.title DESblah, e.name ASC;");
        this.parseAndTransform("select e from org.infinispan.query.dsl.embedded.impl.model.Employee e where e.name = 'same' order by e.title DESblah, e.name ASC");
    }

    @Test
    public void testBeAbleToJoinOnCollectionOfEmbedded() {
        String ickle = "select d.email from org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d";
        SearchQuery<?> result = this.parseAndTransform(ickle);
        Assertions.assertThat((String)result.queryString()).isEqualTo((Object)"+*:*");
        Assertions.assertThat((Object[])this.parse(ickle).getProjections()).containsOnly((Object[])new String[]{"contactDetails.email"});
    }

    @Test
    public void testBeAbleToJoinOnCollectionOfEmbeddedWithEmbedded() {
        String ickle = "select d.email from org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d WHERE d.address.postCode='EA123'";
        IckleParsingResult<Class<?>> parsed = this.parse(ickle);
        SearchQuery<?> query = this.transform(parsed);
        Assertions.assertThat((String)query.queryString()).isEqualTo((Object)"+contactDetails.address.postCode:EA123");
        Assertions.assertThat((Object[])parsed.getProjections()).containsOnly((Object[])new String[]{"contactDetails.email"});
    }

    @Test
    public void testBeAbleToJoinOnCollectionOfEmbeddedWithEmbeddedAndUseInOperator() {
        String ickle = "select d.email from org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d WHERE d.address.postCode IN ('EA123')";
        IckleParsingResult<Class<?>> parsed = this.parse(ickle);
        SearchQuery<?> query = this.transform(parsed);
        Assertions.assertThat((String)query.queryString()).isEqualTo((Object)"+contactDetails.address.postCode:EA123");
        Assertions.assertThat((Object[])parsed.getProjections()).containsOnly((Object[])new String[]{"contactDetails.email"});
    }

    @Test
    public void testBeAbleToJoinOnCollectionOfEmbeddedWithEmbeddedAndUseBetweenOperator() {
        String ickle = "select d.email from org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d WHERE d.address.postCode BETWEEN '0000' AND 'ZZZZ'";
        IckleParsingResult<Class<?>> parsed = this.parse(ickle);
        SearchQuery<?> query = this.transform(parsed);
        Assertions.assertThat((String)query.queryString()).isEqualTo((Object)"+contactDetails.address.postCode:[0000 TO ZZZZ]");
        Assertions.assertThat((Object[])parsed.getProjections()).containsOnly((Object[])new String[]{"contactDetails.email"});
    }

    @Test
    public void testBeAbleToJoinOnCollectionOfEmbeddedWithEmbeddedAndUseGreaterOperator() {
        String ickle = "select d.email from org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d WHERE d.address.postCode > '0000'";
        IckleParsingResult<Class<?>> parsed = this.parse(ickle);
        SearchQuery<?> query = this.transform(parsed);
        Assertions.assertThat((String)query.queryString()).isEqualTo((Object)"+contactDetails.address.postCode:{0000 TO *]");
        Assertions.assertThat((Object[])parsed.getProjections()).containsOnly((Object[])new String[]{"contactDetails.email"});
    }

    @Test
    public void testBeAbleToJoinOnCollectionOfEmbeddedWithEmbeddedAndUseLikeOperator() {
        String ickle = "select d.email from org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d WHERE d.address.postCode LIKE 'EA1%'";
        IckleParsingResult<Class<?>> parsed = this.parse(ickle);
        SearchQuery<?> query = this.transform(parsed);
        Assertions.assertThat((String)query.queryString()).isEqualTo((Object)"+contactDetails.address.postCode:EA1*");
        Assertions.assertThat((Object[])parsed.getProjections()).containsOnly((Object[])new String[]{"contactDetails.email"});
    }

    @Test
    public void testBeAbleToProjectUnqualifiedField() {
        String ickle = "SELECT name, text FROM org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d";
        IckleParsingResult<Class<?>> parsed = this.parse(ickle);
        SearchQuery<?> query = this.transform(parsed);
        Assertions.assertThat((String)query.queryString()).isEqualTo((Object)"+*:*");
        Assertions.assertThat((Object[])parsed.getProjections()).containsOnly((Object[])new String[]{"name", "text"});
    }

    @Test
    public void testBeAbleToProjectUnqualifiedFieldAndQualifiedField() {
        String ickle = "SELECT name, text, d.email FROM org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d";
        IckleParsingResult<Class<?>> parsed = this.parse(ickle);
        SearchQuery<?> query = this.transform(parsed);
        Assertions.assertThat((String)query.queryString()).isEqualTo((Object)"+*:*");
        Assertions.assertThat((Object[])parsed.getProjections()).containsOnly((Object[])new String[]{"name", "text", "contactDetails.email"});
    }

    @Test
    public void testBeAbleToProjectQualifiedField() {
        String ickle = "SELECT e.name, e.text, d.email FROM org.infinispan.query.dsl.embedded.impl.model.Employee e JOIN e.contactDetails d";
        IckleParsingResult<Class<?>> parsed = this.parse(ickle);
        SearchQuery<?> query = this.transform(parsed);
        Assertions.assertThat((String)query.queryString()).isEqualTo((Object)"+*:*");
        Assertions.assertThat((Object[])parsed.getProjections()).containsOnly((Object[])new String[]{"name", "text", "contactDetails.email"});
    }

    @Test
    public void testBeAbleToJoinOnCollectionOfEmbeddedWithTwoEmbeddedCollections() {
        IckleParsingResult<Class<?>> parsed = this.parse(" SELECT d.email  FROM org.infinispan.query.dsl.embedded.impl.model.Employee e  JOIN e.contactDetails d  JOIN e.alternativeContactDetails a WHERE d.address.postCode='EA123' AND a.email='ninja647@mailinator.com'");
        SearchQuery<?> query = this.transform(parsed);
        Assertions.assertThat((String)query.queryString()).isEqualTo((Object)"+(+contactDetails.address.postCode:EA123 +alternativeContactDetails.email:ninja647@mailinator.com)");
        Assertions.assertThat((Object[])parsed.getProjections()).containsOnly((Object[])new String[]{"contactDetails.email"});
    }

    private void assertGeneratedLuceneQuery(String queryString, String expectedLuceneQuery) {
        this.assertGeneratedLuceneQuery(queryString, null, expectedLuceneQuery);
    }

    private void assertGeneratedLuceneQuery(String queryString, Map<String, Object> namedParameters, String expectedLuceneQuery) {
        SearchQuery<?> result = this.parseAndTransform(queryString, namedParameters);
        Assertions.assertThat((String)result.queryString()).isEqualTo((Object)expectedLuceneQuery);
    }

    private SearchQuery<?> parseAndTransform(String queryString) {
        return this.parseAndTransform(queryString, null);
    }

    private SearchQuery<?> parseAndTransform(String queryString, Map<String, Object> namedParameters) {
        IckleParsingResult<Class<?>> ickleParsingResult = this.parse(queryString);
        return this.transform(ickleParsingResult, namedParameters);
    }

    private IckleParsingResult<Class<?>> parse(String queryString) {
        return IckleParser.parse((String)queryString, (ObjectPropertyHelper)this.propertyHelper);
    }

    private SearchQuery<?> transform(IckleParsingResult<Class<?>> ickleParsingResult) {
        return this.transform(ickleParsingResult, null);
    }

    private SearchQuery<?> transform(IckleParsingResult<Class<?>> ickleParsingResult, Map<String, Object> parameters) {
        SearchQueryMaker searchQueryMaker = new SearchQueryMaker(this.searchMapping, (ObjectPropertyHelper)this.propertyHelper);
        return searchQueryMaker.transform(ickleParsingResult, parameters, Employee.class, null).builder(this.searchMapping.getMappingSession()).build();
    }
}

