/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.performance;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.assertj.core.api.Assertions;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.helper.IndexAccessor;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.performance.TuningOptionsAppliedTest")
public class TuningOptionsAppliedTest
extends AbstractInfinispanTest {
    public void verifyFSDirectoryOptions() throws IOException {
        EmbeddedCacheManager embeddedCacheManager = TestCacheManagerFactory.fromXml((String)"nrt-performance-writer.xml");
        try {
            IndexAccessor indexAccessor = IndexAccessor.of(embeddedCacheManager.getCache("Indexed"), Person.class);
            this.verifyShardingOptions(indexAccessor, 6);
            this.verifyUsesFSDirectory(indexAccessor);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{embeddedCacheManager});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{embeddedCacheManager});
    }

    private void verifyShardingOptions(IndexAccessor accessorForTests, int expectedShards) {
        Assertions.assertThat(accessorForTests.getShardsForTests()).hasSize(expectedShards);
    }

    private void verifyUsesFSDirectory(IndexAccessor accessorForTests) {
        Directory directory = accessorForTests.getDirectory();
        Assert.assertTrue((boolean)(directory instanceof FSDirectory));
    }
}

