/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.queries.phrases;

import java.util.HashSet;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.test.Author;
import org.infinispan.query.test.Book;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.queries.phrases.EmbeddedQueryTest")
public class EmbeddedQueryTest
extends SingleCacheManagerTest {
    public EmbeddedQueryTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    private <T> Query<T> createCacheQuery(Class<T> clazz, String alias, String predicate) {
        String queryStr = String.format("FROM %s %s WHERE %s", clazz.getName(), alias, predicate);
        return Search.getQueryFactory((Cache)this.cache).create(queryStr);
    }

    public void testSimpleQuery() {
        Assert.assertEquals((long)0L, (long)this.cache.size());
        this.cache.put((Object)"author#1", (Object)new Author("author1", "surname1"));
        this.cache.put((Object)"author#2", (Object)new Author("author2", "surname2"));
        this.cache.put((Object)"author#3", (Object)new Author("author3", "surname3"));
        Assert.assertEquals((long)3L, (long)this.cache.size());
        Query<Author> query = this.createCacheQuery(Author.class, "a", "a.name:'author1'");
        List result = query.execute().list();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"surname1", (Object)((Author)result.get(0)).getSurname());
    }

    public void testEmbeddedQuery() {
        Assert.assertEquals((long)0L, (long)this.cache.size());
        Author a1 = new Author("author1", "surname1");
        Author a2 = new Author("author2", "surname2");
        Author a3 = new Author("author3", "surname3");
        HashSet<Author> aSet1 = new HashSet<Author>();
        aSet1.add(a1);
        aSet1.add(a2);
        HashSet<Author> aSet2 = new HashSet<Author>();
        aSet2.add(a1);
        aSet2.add(a3);
        HashSet<Author> aSet3 = new HashSet<Author>();
        Book book1 = new Book("Book1", "Some very interesting book", aSet1);
        Book book2 = new Book("Book2", "Not so interesting book", aSet2);
        Book book3 = new Book("Book3", "Book of unknown author", aSet3);
        this.cache.put((Object)"book#1", (Object)book1);
        this.cache.put((Object)"book#2", (Object)book2);
        this.cache.put((Object)"book#3", (Object)book3);
        Assert.assertEquals((long)3L, (long)this.cache.size());
        Query<Book> query = this.createCacheQuery(Book.class, "b", "b.authors.name:'author1'");
        List result = query.execute().list();
        Assert.assertEquals((long)2L, (long)result.size());
        query = this.createCacheQuery(Book.class, "b", "b.description:'interesting'");
        result = query.execute().list();
        Assert.assertEquals((long)2L, (long)result.size());
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(Book.class).addIndexedEntity(Author.class);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }
}

