/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.query.test.Transaction;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.AsyncMassIndexTest")
public class AsyncMassIndexTest
extends MultipleCacheManagersTest {
    protected static final int NUM_NODES = 2;
    protected AbstractCacheTest.CleanupPhase cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = AsyncMassIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        cacheCfg.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(Transaction.class).addProperty("hibernate.search.background_failure_handler", StaticTestingErrorHandler.class.getName());
        this.createClusteredCaches(2, QueryTestSCI.INSTANCE, cacheCfg);
        this.waitForClusterToForm(this.getDefaultCacheName());
    }

    private void populate(int elements) {
        Cache cache = this.cache(0);
        for (int i = 0; i < elements; ++i) {
            cache.put((Object)i, (Object)new Transaction(i + 200, "bytes"));
        }
    }

    @Test
    public void testListener() throws Exception {
        Cache cache = this.cache(0);
        int elements = 50;
        this.populate(elements);
        CompletableFuture future = Search.getIndexer((Cache)cache).run().toCompletableFuture();
        CountDownLatch endLatch = new CountDownLatch(1);
        future.whenComplete((v, t) -> endLatch.countDown());
        endLatch.await();
        this.checkIndex(elements);
    }

    protected void checkIndex(int expectedNumber) {
        Cache c = this.cache(0);
        Query q = Search.getQueryFactory((Cache)c).create("FROM " + Transaction.class.getName());
        long resultSize = q.execute().hitCount().orElse(-1L);
        AssertJUnit.assertEquals((long)expectedNumber, (long)resultSize);
    }
}

