/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.helper.IndexAccessor;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.config.MultipleCachesTest")
public class MultipleCachesTest
extends SingleCacheManagerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm;
        String config = TestingUtil.wrapXMLWithSchema((String)"<cache-container default-cache=\"default\">   <local-cache name=\"default\">\n      <indexing enabled=\"false\" />\n   </local-cache>\n   <local-cache name=\"indexingenabled\">\n      <indexing storage=\"local-heap\">\n         <indexed-entities>\n            <indexed-entity>org.infinispan.query.test.Person</indexed-entity>\n         </indexed-entities>\n      </indexing>\n   </local-cache>\n</cache-container>");
        log.tracef("Using test configuration:\n%s", (Object)config);
        try (ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());){
            cm = TestCacheManagerFactory.fromStream((InputStream)is);
        }
        this.cache = cm.getCache();
        return cm;
    }

    @Test(expectedExceptions={ParsingException.class})
    public void queryNotIndexedCache() {
        this.cacheManager.defineConfiguration("notIndexedA", this.cacheManager.getDefaultCacheConfiguration());
        Cache notIndexedCache = this.cacheManager.getCache("notIndexedA");
        notIndexedCache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        Query fullTextQuery = TestQueryHelperFactory.createCacheQuery(Person.class, this.cache, "name", "Name");
        AssertJUnit.assertEquals((long)1L, (long)fullTextQuery.execute().hitCount().orElse(-1L));
        List l = fullTextQuery.execute().list();
        AssertJUnit.assertEquals((int)1, (int)l.size());
        Person p = (Person)l.get(0);
        AssertJUnit.assertEquals((String)"A Person's Name", (String)p.getName());
        AssertJUnit.assertEquals((String)"A paragraph containing some text", (String)p.getBlurb());
        AssertJUnit.assertEquals((int)75, (int)p.getAge());
    }

    @Test
    public void notIndexedCacheNormalUse() {
        this.cacheManager.defineConfiguration("notIndexedB", this.cacheManager.getDefaultCacheConfiguration());
        Cache notIndexedCache = this.cacheManager.getCache("notIndexedB");
        notIndexedCache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        assert (notIndexedCache.get((Object)"1") != null);
    }

    @Test
    public void indexedCache() {
        Cache indexedCache = this.cacheManager.getCache("indexingenabled");
        this.useQuery((Cache<Object, Object>)indexedCache);
    }

    private void useQuery(Cache<Object, Object> indexedCache) {
        indexedCache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        Query cq = TestQueryHelperFactory.createCacheQuery(Person.class, indexedCache, "name", "Name");
        AssertJUnit.assertEquals((long)1L, (long)cq.execute().hitCount().orElse(-1L));
        List l = cq.execute().list();
        AssertJUnit.assertEquals((int)1, (int)l.size());
        Person p = (Person)l.get(0);
        AssertJUnit.assertEquals((String)"A Person's Name", (String)p.getName());
        AssertJUnit.assertEquals((String)"A paragraph containing some text", (String)p.getBlurb());
        AssertJUnit.assertEquals((int)75, (int)p.getAge());
        IndexAccessor accessorTest = IndexAccessor.of(indexedCache, Person.class);
        Assertions.assertThat((Object)accessorTest.getIndexManager()).isNotNull();
        Assertions.assertThat((Object)accessorTest.getDirectory()).isInstanceOf(ByteBuffersDirectory.class);
    }
}

