/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Base64;
import java.util.UUID;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Util;
import org.infinispan.query.Transformer;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.test.CustomKey;
import org.infinispan.query.test.CustomKey2;
import org.infinispan.query.test.CustomKey3;
import org.infinispan.query.test.CustomKey3Transformer;
import org.infinispan.query.test.NonSerializableKey;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.backend.KeyTransformationHandlerTest")
public class KeyTransformationHandlerTest {
    private KeyTransformationHandler keyTransformationHandler;
    private final UUID randomUUID = Util.threadLocalRandomUUID();

    @BeforeMethod
    public void beforeMethod() {
        this.keyTransformationHandler = new KeyTransformationHandler(null);
    }

    public void testKeyToStringWithStringAndPrimitives() {
        String s = this.keyTransformationHandler.keyToString((Object)"key");
        assert (s.equals("S:key"));
        s = this.keyTransformationHandler.keyToString((Object)1);
        assert (s.equals("I:1"));
        s = this.keyTransformationHandler.keyToString((Object)true);
        assert (s.equals("B:true"));
        s = this.keyTransformationHandler.keyToString((Object)1);
        assert (s.equals("X:1"));
        s = this.keyTransformationHandler.keyToString((Object)1L);
        assert (s.equals("L:1"));
        s = this.keyTransformationHandler.keyToString((Object)1);
        assert (s.equals("Y:1"));
        s = this.keyTransformationHandler.keyToString((Object)Float.valueOf(1.0f));
        assert (s.equals("F:1.0"));
        s = this.keyTransformationHandler.keyToString((Object)Character.valueOf('A'));
        assert (s.equals("C:A"));
        s = this.keyTransformationHandler.keyToString((Object)1.0);
        assert (s.equals("D:1.0"));
        s = this.keyTransformationHandler.keyToString((Object)this.randomUUID);
        assert (s.equals("U:" + this.randomUUID));
        byte[] arr = new byte[]{1, 2, 3, 4, 5, 6};
        s = this.keyTransformationHandler.keyToString((Object)arr);
        assert (s.equals("A:" + Base64.getEncoder().encodeToString(arr)));
    }

    public void testStringToKeyWithStringAndPrimitives() {
        Object key = this.keyTransformationHandler.stringToKey("S:key1");
        assert (key.getClass().equals(String.class));
        assert (key.equals("key1"));
        key = this.keyTransformationHandler.stringToKey("I:2");
        assert (key.getClass().equals(Integer.class));
        assert (key.equals(2));
        key = this.keyTransformationHandler.stringToKey("Y:3");
        assert (key.getClass().equals(Byte.class));
        assert (key.equals((byte)3));
        key = this.keyTransformationHandler.stringToKey("F:4.0");
        assert (key.getClass().equals(Float.class));
        assert (key.equals(Float.valueOf(4.0f)));
        key = this.keyTransformationHandler.stringToKey("L:5");
        assert (key.getClass().equals(Long.class));
        assert (key.equals(5L));
        key = this.keyTransformationHandler.stringToKey("X:6");
        assert (key.getClass().equals(Short.class));
        assert (key.equals((short)6));
        key = this.keyTransformationHandler.stringToKey("B:true");
        assert (key.getClass().equals(Boolean.class));
        assert (key.equals(true));
        key = this.keyTransformationHandler.stringToKey("D:8.0");
        assert (key.getClass().equals(Double.class));
        assert (key.equals(8.0));
        key = this.keyTransformationHandler.stringToKey("C:9");
        assert (key.getClass().equals(Character.class));
        assert (key.equals(Character.valueOf('9')));
        key = this.keyTransformationHandler.stringToKey("U:" + this.randomUUID);
        assert (key.getClass().equals(UUID.class));
        assert (key.equals(this.randomUUID));
        byte[] arr = new byte[]{1, 2, 3, 4, 5, 6};
        key = this.keyTransformationHandler.stringToKey("A:" + Base64.getEncoder().encodeToString(arr));
        AssertJUnit.assertEquals((byte[])arr, (byte[])((byte[])key));
    }

    @Test(expectedExceptions={CacheException.class})
    public void testStringToUnknownKey() {
        this.keyTransformationHandler.stringToKey("Z:someKey");
    }

    @Test(expectedExceptions={CacheException.class})
    public void testStringToKeyWithInvalidTransformer() {
        this.keyTransformationHandler.stringToKey("T:org.infinispan.InexistentTransformer:key1");
    }

    public void testStringToKeyWithCustomTransformable() {
        CustomKey customKey = new CustomKey(88, 8800, 12889976);
        String strRep = this.keyTransformationHandler.keyToString((Object)customKey);
        Object keyAgain = this.keyTransformationHandler.stringToKey(strRep);
        AssertJUnit.assertEquals((Object)customKey, (Object)keyAgain);
    }

    public void testStringToKeyWithDefaultTransformer() {
        CustomKey2 ck2 = new CustomKey2(Integer.MAX_VALUE, Integer.MIN_VALUE, 0);
        String strRep = this.keyTransformationHandler.keyToString((Object)ck2);
        Object keyAgain = this.keyTransformationHandler.stringToKey(strRep);
        AssertJUnit.assertEquals((Object)ck2, (Object)keyAgain);
    }

    public void testStringToKeyWithRegisteredTransformer() {
        this.keyTransformationHandler.registerTransformer(CustomKey3.class, CustomKey3Transformer.class);
        CustomKey3 key = new CustomKey3("str");
        String string = this.keyTransformationHandler.keyToString((Object)key);
        Object keyAgain = this.keyTransformationHandler.stringToKey(string);
        AssertJUnit.assertEquals((Object)key, (Object)keyAgain);
    }

    @Test(expectedExceptions={CacheException.class})
    public void testStringToKeyWithNoAvailableTransformer() {
        CustomKey3 key = new CustomKey3("str");
        String string = this.keyTransformationHandler.keyToString((Object)key);
        Object keyAgain = this.keyTransformationHandler.stringToKey(string);
        AssertJUnit.assertEquals((Object)key, (Object)keyAgain);
    }

    @Test(expectedExceptions={CacheException.class})
    public void testKeyToStringWithExceptionalTransformer() {
        this.keyTransformationHandler.registerTransformer(CustomKey2.class, ExceptionThrowingTransformer.class);
        CustomKey2 key = new CustomKey2(1, 2, 3);
        this.keyTransformationHandler.keyToString((Object)key);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testKeyToStringWithDefaultTransformerForNonSerializableObject() {
        NonSerializableKey key = new NonSerializableKey("test");
        this.keyTransformationHandler.keyToString((Object)key);
    }

    public static class ExceptionThrowingTransformer
    implements Transformer {
        public ExceptionThrowingTransformer() {
            throw new RuntimeException("Shaka Laka Boom Boom");
        }

        public Object fromString(String s) {
            return null;
        }

        public String toString(Object customType) {
            return null;
        }
    }
}

