/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.query.Search;
import org.infinispan.query.core.stats.IndexInfo;
import org.infinispan.query.core.stats.IndexStatistics;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.query.test.QueryTestSCI;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.LocalIndexStateTransferTest")
public class LocalIndexSyncStateTransferTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(2, QueryTestSCI.INSTANCE, this.getBuilder());
    }

    protected ConfigurationBuilder getBuilder() {
        ConfigurationBuilder builder = LocalIndexSyncStateTransferTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(Person.class).addIndexedEntity(AnotherGrassEater.class);
        return builder;
    }

    private void assertIndexesSynced() {
        List caches = this.caches();
        caches.forEach(this::assertIndexesSynced);
    }

    private Map<String, Long> getIndexCountPerEntity(Cache<Integer, Object> cache) {
        IndexStatistics indexStatistics = Search.getSearchStatistics(cache).getIndexStatistics();
        Map stringIndexInfoMap = (Map)FunctionalTestUtils.await(indexStatistics.computeIndexInfos().toCompletableFuture());
        return stringIndexInfoMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IndexInfo)e.getValue()).count()));
    }

    private void assertIndexesSynced(Cache<Integer, Object> c) {
        String address = c.getAdvancedCache().getRpcManager().getAddress().toString();
        Map<Class<?>, AtomicInteger> countPerEntity = this.getEntityCountPerClass(c);
        Map<String, Long> indexInfo = this.getIndexCountPerEntity(c);
        countPerEntity.forEach((entity, count) -> {
            long indexed = (Long)indexInfo.get(entity.getName());
            Supplier<String> messageSupplier = () -> String.format("On node %s index contains %d entries for entity %s, but data container has %d", address, indexed, entity.getName(), count.get());
            LocalIndexSyncStateTransferTest.eventually(messageSupplier, () -> indexed == (long)count.get());
        });
    }

    protected Map<Class<?>, AtomicInteger> getEntityCountPerClass(Cache<Integer, Object> c) {
        HashMap countPerEntity = new HashMap();
        c.getAdvancedCache().getDataContainer().forEach(e -> {
            Class<?> entity = e.getValue().getClass();
            countPerEntity.computeIfAbsent(entity, aClass -> new AtomicInteger(0)).incrementAndGet();
        });
        return countPerEntity;
    }

    public void testIndexSyncedDuringST() {
        Cache cache = this.cache(0);
        for (int i = 0; i < 10; ++i) {
            cache.put((Object)i, (Object)new Person("person" + i, "blurb" + i, i + 10));
        }
        this.assertIndexesSynced();
        this.addClusterEnabledCacheManager(QueryTestSCI.INSTANCE, this.getBuilder()).getCache();
        this.assertIndexesSynced();
        this.killMember(2);
        this.assertIndexesSynced();
    }
}

