/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl.model;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.DocumentId;
import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.api.annotations.indexing.Embedded;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.api.annotations.indexing.Keyword;
import org.infinispan.api.annotations.indexing.Text;
import org.infinispan.api.annotations.indexing.option.Structure;
import org.infinispan.query.dsl.embedded.impl.model.Company;

@Indexed
public class Employee {
    public String id;
    public String name;
    public long position;
    public Long code;
    public String text;
    public String title;
    public String otherInfo;
    public Company author;
    public List<ContactDetails> contactDetails = new ArrayList<ContactDetails>();
    public List<ContactDetails> alternativeContactDetails = new ArrayList<ContactDetails>();

    @DocumentId
    @Basic(projectable=true)
    public String getId() {
        return this.id;
    }

    @Keyword(projectable=true)
    public String getName() {
        return this.name;
    }

    @Basic(sortable=true)
    public Long getPosition() {
        return this.position;
    }

    @Basic(sortable=true, indexNullAs="-1")
    public Long getCode() {
        return this.code;
    }

    @Text(projectable=true)
    public String getText() {
        return this.text;
    }

    @Basic(sortable=true)
    public String getTitle() {
        return this.title;
    }

    @Text(name="analyzedInfo")
    @Basic.List(value={@Basic(name="someMoreInfo"), @Basic(name="sameInfo")})
    public String getOtherInfo() {
        return this.otherInfo;
    }

    @Embedded(structure=Structure.FLATTENED)
    public Company getAuthor() {
        return this.author;
    }

    @Embedded(structure=Structure.FLATTENED)
    public List<ContactDetails> getContactDetails() {
        return this.contactDetails;
    }

    @Embedded(structure=Structure.FLATTENED)
    public List<ContactDetails> getAlternativeContactDetails() {
        return this.alternativeContactDetails;
    }

    public static class ContactDetails {
        public String email;
        public String phoneNumber;
        public ContactAddress address;

        @Basic(projectable=true)
        public String getEmail() {
            return this.email;
        }

        @Basic
        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        @Embedded(structure=Structure.FLATTENED)
        public ContactAddress getAddress() {
            return this.address;
        }

        public static class ContactAddress {
            public String address;
            public String postCode;
            public List<ContactAddress> alternatives = new ArrayList<ContactAddress>();

            @Basic
            public String getAddress() {
                return this.address;
            }

            @Basic
            public String getPostCode() {
                return this.postCode;
            }

            @Embedded(structure=Structure.FLATTENED)
            public List<ContactAddress> getAlternatives() {
                return this.alternatives;
            }
        }
    }
}

