/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.testdomain.hsearch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.api.annotations.indexing.Embedded;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.query.dsl.embedded.testdomain.Account;
import org.infinispan.query.dsl.embedded.testdomain.Limits;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.LimitsHS;

@Indexed
public class AccountHS
implements Account,
Serializable {
    @ProtoField(number=1, defaultValue="0")
    int id;
    @ProtoField(number=2)
    String description;
    @ProtoField(number=3)
    Date creationDate;
    @ProtoField(number=4)
    LimitsHS limits;
    @ProtoField(number=5)
    LimitsHS hardLimits;
    @ProtoField(number=6, collectionImplementation=ArrayList.class)
    List<byte[]> blurb = new ArrayList<byte[]>();
    @ProtoField(number=7)
    Account.Currency[] currencies = new Account.Currency[0];

    public AccountHS() {
        this.hardLimits = new LimitsHS();
        this.hardLimits.setMaxTransactionLimit(5000.0);
        this.hardLimits.setMaxDailyLimit(10000.0);
    }

    @Override
    @Basic(projectable=true, sortable=true)
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    @Basic(projectable=true, sortable=true)
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Basic(projectable=true, sortable=true)
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    @Embedded
    public LimitsHS getLimits() {
        return this.limits;
    }

    @Override
    public void setLimits(Limits limits) {
        this.limits = (LimitsHS)limits;
    }

    @Override
    @Embedded
    public LimitsHS getHardLimits() {
        return this.hardLimits;
    }

    @Override
    public void setHardLimits(Limits hardLimits) {
        this.hardLimits = (LimitsHS)hardLimits;
    }

    @Override
    public List<byte[]> getBlurb() {
        return this.blurb;
    }

    @Override
    public void setBlurb(List<byte[]> blurb) {
        this.blurb = blurb;
    }

    private boolean blurbEquals(List<byte[]> otherBlurbs) {
        if (otherBlurbs == this.blurb) {
            return true;
        }
        if (otherBlurbs == null || this.blurb == null || otherBlurbs.size() != this.blurb.size()) {
            return false;
        }
        for (int i = 0; i < this.blurb.size(); ++i) {
            if (Arrays.equals(this.blurb.get(i), otherBlurbs.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    @Basic(projectable=true)
    public Account.Currency[] getCurrencies() {
        return this.currencies;
    }

    @Override
    public void setCurrencies(Account.Currency[] currencies) {
        this.currencies = currencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHS account = (AccountHS)o;
        return this.id == account.id && Objects.equals(this.description, account.description) && Objects.equals(this.creationDate, account.creationDate) && Objects.equals(this.limits, account.limits) && Objects.equals(this.hardLimits, account.hardLimits) && this.blurbEquals(account.blurb) && Arrays.equals((Object[])this.currencies, (Object[])account.currencies);
    }

    public int hashCode() {
        int blurbHash = 0;
        if (this.blurb != null) {
            for (byte[] b : this.blurb) {
                blurbHash = 31 * blurbHash + Arrays.hashCode(b);
            }
        }
        return Objects.hash(this.id, this.description, this.creationDate, this.limits, this.hardLimits, blurbHash, Arrays.hashCode((Object[])this.currencies));
    }

    public String toString() {
        return "AccountHS{id=" + this.id + ", description='" + this.description + "', creationDate='" + this.creationDate + "', limits=" + this.limits + ", hardLimits=" + this.hardLimits + ", blurb=" + (this.blurb != null ? this.blurb.stream().map(Arrays::toString).collect(Collectors.toList()) : "null") + ", currencies=" + Arrays.toString((Object[])this.currencies) + "}";
    }
}

