/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.encoding;

import java.util.List;
import java.util.OptionalLong;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.model.Game;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.query.encoding.ProtobufEncodedIndexedCacheTest")
public class ProtobufEncodedIndexedCacheTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(false);
        builder.encoding().mediaType("application/x-protostream").indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("org.infinispan.query.model.Game");
        this.cacheManager = TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)Game.GameSchema.INSTANCE, null);
        this.cache = ((EmbeddedCacheManagerAdmin)this.cacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).getOrCreateCache("default", builder.build());
        return this.cacheManager;
    }

    @Test
    public void test() {
        this.cache.put((Object)1, (Object)new Game("Civilization 1", "The best video game of all time!"));
        QueryFactory factory = Search.getQueryFactory((Cache)this.cache);
        Query query = factory.create("from org.infinispan.query.model.Game where description : 'game'");
        QueryResult result = query.execute();
        Assertions.assertThat((OptionalLong)result.hitCount()).hasValue(1L);
        Assertions.assertThat((List)result.list()).extracting("name").contains(new Object[]{"Civilization 1"});
    }
}

