/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.field;

import java.util.List;
import java.util.OptionalLong;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.model.Color;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.parameter.IndexFieldNameTest")
public class MultipleIndexFieldAnnotationsTest
extends SingleCacheManagerTest {
    public static final String RED_DESCRIPTION = "Red is the color at the long wavelength end of the visible spectrum of light";
    public static final String GREEN_DESCRIPTION = "Green is the color between cyan and yellow on the visible spectrum.";
    public static final String BLUE_DESCRIPTION = "Blue is one of the three primary colours in the RYB colour model (traditional color theory), as well as in the RGB (additive) colour model.";

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(false);
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(Color.class);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod() {
        this.cache.put((Object)1, (Object)new Color("red", RED_DESCRIPTION));
        this.cache.put((Object)2, (Object)new Color("green", GREEN_DESCRIPTION));
        this.cache.put((Object)3, (Object)new Color("blue", BLUE_DESCRIPTION));
    }

    @Test
    public void testTargetingDifferentIndexFields() {
        QueryFactory factory = Search.getQueryFactory((Cache)this.cache);
        Query query = factory.create("from org.infinispan.query.model.Color where name = 'red'");
        QueryResult result = query.execute();
        Assertions.assertThat((OptionalLong)result.hitCount()).hasValue(1L);
        Assertions.assertThat((List)result.list()).extracting("name").contains(new Object[]{"red"});
        query = factory.create(String.format("from %s where desc1 = '%s'", Color.class.getName(), RED_DESCRIPTION));
        result = query.execute();
        Assertions.assertThat((OptionalLong)result.hitCount()).hasValue(1L);
        Assertions.assertThat((List)result.list()).extracting("name").contains(new Object[]{"red"});
        query = factory.create(String.format("from %s where desc2 = '%s'", Color.class.getName(), BLUE_DESCRIPTION));
        result = query.execute();
        Assertions.assertThat((OptionalLong)result.hitCount()).hasValue(1L);
        Assertions.assertThat((List)result.list()).extracting("name").contains(new Object[]{"blue"});
        query = factory.create(String.format("from %s where desc3 : 'cyan'", Color.class.getName()));
        result = query.execute();
        Assertions.assertThat((OptionalLong)result.hitCount()).hasValue(1L);
        Assertions.assertThat((List)result.list()).extracting("name").contains(new Object[]{"green"});
    }
}

