/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.parameter;

import java.util.List;
import java.util.OptionalLong;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.model.Book;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.parameter.IndexFieldNameTest")
public class IndexFieldNameTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(false);
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(Book.class);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod() {
        Book book1 = new Book();
        book1.setTitle("is*and");
        book1.setDescription("A pl*ce surrounded by the sea.");
        this.cache.put((Object)1, (Object)book1);
        Book book2 = new Book();
        book2.setTitle("home");
        book2.setDescription("The pl*ce where I'm staying.");
        this.cache.put((Object)2, (Object)book2);
    }

    public void useDifferentIndexFieldNames() {
        QueryFactory factory = Search.getQueryFactory((Cache)this.cache);
        Query query = factory.create("from org.infinispan.query.model.Book where naming : 'pl*ce' order by label");
        QueryResult result = query.execute();
        Assertions.assertThat((OptionalLong)result.hitCount()).hasValue(2L);
        Assertions.assertThat((List)result.list()).extracting("title").contains(new Object[]{"is*and", "home"});
    }
}

