/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.parameter;

import java.util.List;
import java.util.OptionalLong;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.model.Book;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.parameter.SpecialCharTextTest")
public class SpecialCharTextTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(false);
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(Book.class);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod() {
        Book book = new Book();
        book.setTitle("is*and");
        book.setDescription("A pl*ce surrounded by the sea.");
        this.cache.put((Object)1, (Object)book);
    }

    public void fulltext() {
        QueryFactory factory = Search.getQueryFactory((Cache)this.cache);
        Query query = factory.create("from org.infinispan.query.model.Book where naming : 'pl*ce'");
        QueryResult result = query.execute();
        Assertions.assertThat((OptionalLong)result.hitCount()).hasValue(1L);
        Assertions.assertThat((List)result.list()).extracting("title").contains(new Object[]{"is*and"});
    }

    public void generic() {
        QueryFactory factory = Search.getQueryFactory((Cache)this.cache);
        Query query = factory.create("from org.infinispan.query.model.Book where title = 'is*and'");
        QueryResult result = query.execute();
        Assertions.assertThat((OptionalLong)result.hitCount()).hasValue(1L);
        Assertions.assertThat((List)result.list()).extracting("title").contains(new Object[]{"is*and"});
    }
}

