/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.projection;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.infinispan.Cache;
import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.api.annotations.indexing.Text;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.search.mapper.common.impl.EntityReferenceImpl;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.projection.ProjectionTest")
public class ProjectionTest
extends SingleCacheManagerTest {
    private QueryFactory queryFactory;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(Foo.class);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
        Cache cache = cacheManager.getCache();
        this.queryFactory = Search.getQueryFactory((Cache)cache);
        return cacheManager;
    }

    @Test
    public void testQueryProjectionWithSingleField() {
        this.cache.put((Object)"1", (Object)new Foo("bar1", "baz1"));
        Query cacheQuery = this.createProjectionQuery("bar");
        this.assertQueryReturns(cacheQuery, new Object[]{"bar1"});
    }

    @Test
    public void testQueryProjectionWithMultipleFields() {
        this.cache.put((Object)"1", (Object)new Foo("bar1", "baz1"));
        Query cacheQuery = this.createProjectionQuery("bar", "baz");
        this.assertQueryReturns(cacheQuery, new Object[]{"bar1", "baz1"});
    }

    @Test
    public void testMixedProjections() {
        Foo foo = new Foo("bar1", "baz4");
        this.cache.put((Object)"1", (Object)foo);
        Query cacheQuery = this.createProjectionQuery("baz", "bar");
        this.assertQueryReturns(cacheQuery, new Object[]{foo.baz, foo.bar});
    }

    private <T> Query<T> createProjectionQuery(String ... projection) {
        String selectClause = String.join((CharSequence)",", projection);
        String q = String.format("SELECT %s FROM %s WHERE bar:'bar1'", selectClause, Foo.class.getName());
        return this.queryFactory.create(q);
    }

    private void assertQueryReturns(Query<?> cacheQuery, Object expected) {
        this.assertQueryListContains(cacheQuery.execute().list(), expected);
        try (CloseableIterator eagerIterator = cacheQuery.iterator();){
            this.assertQueryIteratorContains(eagerIterator, expected);
        }
    }

    private void assertQueryListContains(List<?> list, Object expected) {
        assert (list.size() == 1);
        Object value = list.get(0);
        Assertions.assertThat(value).isEqualTo(expected);
    }

    private void assertQueryIteratorContains(CloseableIterator<?> iterator, Object expected) {
        assert (iterator.hasNext());
        Object value = iterator.next();
        Assertions.assertThat((Object)value).isEqualTo(expected);
        assert (!iterator.hasNext());
    }

    private static EntityReferenceImpl entityReference(Class<?> type, String key) {
        return new EntityReferenceImpl(PojoRawTypeIdentifier.of(type), type.getSimpleName(), (Object)key);
    }

    @Indexed(index="FooIndex")
    public static class Foo {
        private String bar;
        private String baz;

        public Foo(String bar, String baz) {
            this.bar = bar;
            this.baz = baz;
        }

        @Text
        public String getBar() {
            return this.bar;
        }

        @Basic(projectable=true)
        public String getBaz() {
            return this.baz;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Foo foo = (Foo)o;
            if (this.bar != null ? !this.bar.equals(foo.bar) : foo.bar != null) {
                return false;
            }
            return this.baz != null ? this.baz.equals(foo.baz) : foo.baz == null;
        }

        public int hashCode() {
            return this.bar.hashCode();
        }
    }
}

