/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.startup;

import java.util.OptionalLong;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStartupMode;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.model.Developer;
import org.infinispan.query.model.ModelSchemaImpl;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.startup.IndexStartupModeTest")
public class IndexStartupModeTest
extends AbstractInfinispanTest {
    private final String fileStoreDataLocation = CommonsTestingUtil.tmpDirectory((String[])new String[]{"IndexStartupModeTest", "fileStoreDataLocation"});
    private final String fileStoreIndexLocation = CommonsTestingUtil.tmpDirectory((String[])new String[]{"IndexStartupModeTest", "fileStoreIndexLocation"});
    private final String indexesLocation = CommonsTestingUtil.tmpDirectory((String[])new String[]{"IndexStartupModeTest", "indexes"});
    private EmbeddedCacheManager cacheManager;
    private Cache<String, Developer> cache;
    private QueryFactory queryFactory;

    public void volatileDataNonVolatileIndexes_purgeAtStartup() {
        this.execute(IndexStorage.FILESYSTEM, false, IndexStartupMode.PURGE, () -> {
            this.verifyMatches(0, "fax4ever");
            this.cache.put((Object)"fabio", (Object)new Developer("fax4ever", "fax@redmail.io", "Infinispan developer", 0));
            this.verifyMatches(1, "fax4ever");
        });
        this.execute(IndexStorage.FILESYSTEM, false, IndexStartupMode.NONE, () -> {
            Assertions.assertThat((Object)((Developer)this.cache.get((Object)"fabio"))).isNull();
            this.verifyMatches(1, "fax4ever");
        });
        this.execute(IndexStorage.FILESYSTEM, false, IndexStartupMode.PURGE, () -> {
            this.verifyMatches(0, "fax4ever");
            this.cache.put((Object)"fabio", (Object)new Developer("fax4ever", "fax@redmail.io", "Infinispan developer", 0));
            this.verifyMatches(1, "fax4ever");
        });
        this.execute(IndexStorage.FILESYSTEM, false, IndexStartupMode.NONE, () -> {
            Assertions.assertThat((Object)((Developer)this.cache.get((Object)"fabio"))).isNull();
            this.verifyMatches(1, "fax4ever");
        });
        this.execute(IndexStorage.FILESYSTEM, false, IndexStartupMode.AUTO, () -> this.verifyMatches(0, "fax4ever"));
    }

    public void nonVolatileDataVolatileIndexes_reindexAtStartup() {
        this.execute(IndexStorage.LOCAL_HEAP, true, IndexStartupMode.NONE, () -> {
            this.verifyMatches(0, "fax4ever");
            this.cache.put((Object)"fabio", (Object)new Developer("fax4ever", "fax@redmail.io", "Infinispan developer", 0));
            this.verifyMatches(1, "fax4ever");
        });
        this.execute(IndexStorage.LOCAL_HEAP, true, IndexStartupMode.NONE, () -> {
            Developer fabio = (Developer)this.cache.get((Object)"fabio");
            Assertions.assertThat((Object)fabio).isNotNull();
            Assertions.assertThat((Object)fabio).extracting(new String[]{"nick"}).containsExactly(new Object[]{"fax4ever"});
            this.verifyMatches(0, "fax4ever");
        });
        this.execute(IndexStorage.LOCAL_HEAP, true, IndexStartupMode.REINDEX, () -> {
            Developer fabio = (Developer)this.cache.get((Object)"fabio");
            Assertions.assertThat((Object)fabio).isNotNull();
            Assertions.assertThat((Object)fabio).extracting(new String[]{"nick"}).containsExactly(new Object[]{"fax4ever"});
            IndexStartupModeTest.eventually(() -> this.matches(1L, "fax4ever"));
        });
        this.execute(IndexStorage.LOCAL_HEAP, true, IndexStartupMode.NONE, () -> {
            Developer fabio = (Developer)this.cache.get((Object)"fabio");
            Assertions.assertThat((Object)fabio).isNotNull();
            Assertions.assertThat((Object)fabio).extracting(new String[]{"nick"}).containsExactly(new Object[]{"fax4ever"});
            this.verifyMatches(0, "fax4ever");
        });
        this.execute(IndexStorage.LOCAL_HEAP, true, IndexStartupMode.AUTO, () -> {
            Developer fabio = (Developer)this.cache.get((Object)"fabio");
            Assertions.assertThat((Object)fabio).isNotNull();
            Assertions.assertThat((Object)fabio).extracting(new String[]{"nick"}).containsExactly(new Object[]{"fax4ever"});
            IndexStartupModeTest.eventually(() -> this.matches(1L, "fax4ever"));
        });
    }

    @BeforeClass(alwaysRun=true)
    public void setUp() {
        Util.recursiveFileRemove((String)this.fileStoreDataLocation);
        Util.recursiveFileRemove((String)this.fileStoreIndexLocation);
        Util.recursiveFileRemove((String)this.indexesLocation);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        Util.recursiveFileRemove((String)this.fileStoreDataLocation);
        Util.recursiveFileRemove((String)this.fileStoreIndexLocation);
        Util.recursiveFileRemove((String)this.indexesLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(IndexStorage storage, boolean cacheStorage, IndexStartupMode startupMode, Runnable runnable) {
        try {
            this.recreateCacheManager(storage, cacheStorage, startupMode);
            runnable.run();
        }
        catch (Throwable throwable) {
            IndexStartupModeTest.eventually(() -> !Search.getSearchStatistics(this.cache).getIndexStatistics().reindexing());
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
            throw throwable;
        }
        IndexStartupModeTest.eventually(() -> !Search.getSearchStatistics(this.cache).getIndexStatistics().reindexing());
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    private void recreateCacheManager(IndexStorage storage, boolean persistentCacheData, IndexStartupMode startupMode) {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.indexing().enable().storage(storage).path(this.indexesLocation).startupMode(startupMode).addIndexedEntity(Developer.class);
        if (persistentCacheData) {
            cfg.persistence().addSoftIndexFileStore().dataLocation(this.fileStoreDataLocation).indexLocation(this.fileStoreIndexLocation).preload(true);
        }
        this.cacheManager = TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)new ModelSchemaImpl(), (ConfigurationBuilder)cfg);
        this.cache = this.cacheManager.getCache();
        this.queryFactory = Search.getQueryFactory(this.cache);
    }

    private void verifyMatches(int i, String nick) {
        String query = String.format("from %s where nick = '%s'", Developer.class.getName(), nick);
        Assertions.assertThat((OptionalLong)this.queryFactory.create(query).execute().hitCount()).hasValue((long)i);
    }

    private boolean matches(long i, String nick) {
        String query = String.format("from %s where nick = '%s'", Developer.class.getName(), nick);
        OptionalLong hitCount = this.queryFactory.create(query).execute().hitCount();
        Assertions.assertThat((OptionalLong)hitCount).isPresent();
        return hitCount.getAsLong() == i;
    }
}

