/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.tx;

import javax.transaction.TransactionManager;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.api.annotations.indexing.Text;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.tx.SCIImpl;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.tx.TransactionalQueryTest")
public class TransactionalQueryTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(Session.class);
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)new SCIImpl(), (ConfigurationBuilder)cfg);
    }

    @BeforeMethod
    public void initialize() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(), () -> {
            for (int i = 0; i < 100; ++i) {
                this.cache.put((Object)String.valueOf(i), (Object)new Session(String.valueOf(i)));
            }
            return null;
        });
    }

    public void run() throws Exception {
        TestQueryHelperFactory.createCacheQuery(Session.class, this.cache, "Id", "2");
        TestingUtil.withTx((TransactionManager)this.tm(), () -> {
            this.cache.remove((Object)"50");
            return null;
        });
        TestingUtil.withTx((TransactionManager)this.tm(), () -> {
            this.cache.remove((Object)"200");
            return null;
        });
    }

    @AutoProtoSchemaBuilder(includeClasses={Session.class}, schemaFileName="test.query.tx.TransactionalQueryTest.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.TransactionalQueryTest", service=false)
    static interface SCI
    extends SerializationContextInitializer {
    }

    @Indexed(index="SessionIndex")
    public static class Session {
        private String m_id;

        @ProtoFactory
        Session(String id) {
            this.m_id = id;
        }

        @Text(name="Id")
        @ProtoField(number=1)
        public String getId() {
            return this.m_id;
        }
    }
}

