/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hibernate.search.util.common.SearchException;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.SearchTimeoutException;
import org.infinispan.query.clustered.ClusteredQueryInvoker;
import org.infinispan.query.clustered.ClusteredQueryOperation;
import org.infinispan.query.clustered.DistributedEntryIterator;
import org.infinispan.query.clustered.DistributedIterator;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.core.impl.QueryResultImpl;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.impl.IndexedQuery;
import org.infinispan.query.impl.IndexedQueryImpl;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.transport.Address;

public final class DistributedIndexedQueryImpl<E>
extends IndexedQueryImpl<E> {
    private Integer resultSize;
    private final ClusteredQueryInvoker invoker;
    private int maxResults = Integer.MAX_VALUE;
    private int firstResult = 0;

    public DistributedIndexedQueryImpl(QueryDefinition queryDefinition, AdvancedCache<?, ?> cache, LocalQueryStatistics queryStatistics) {
        super(queryDefinition, cache, queryStatistics);
        this.invoker = new ClusteredQueryInvoker(cache, queryStatistics);
    }

    @Override
    public IndexedQuery<E> maxResults(int maxResults) {
        this.maxResults = maxResults;
        return super.maxResults(maxResults);
    }

    @Override
    public IndexedQuery<E> firstResult(int firstResult) {
        this.firstResult = firstResult;
        return super.firstResult(firstResult);
    }

    @Override
    public int getResultSize() {
        this.partitionHandlingSupport.checkCacheAvailable();
        if (this.resultSize == null) {
            List<QueryResponse> responses = this.invoker.broadcast(ClusteredQueryOperation.getResultSize(this.queryDefinition));
            int accumulator = 0;
            for (QueryResponse response : responses) {
                accumulator = (int)((long)accumulator + response.getResultSize());
            }
            this.resultSize = accumulator;
        }
        return this.resultSize;
    }

    @Override
    public CloseableIterator<E> iterator() throws SearchException {
        this.partitionHandlingSupport.checkCacheAvailable();
        this.queryDefinition.setMaxResults(this.getNodeMaxResults());
        ClusteredQueryOperation command = ClusteredQueryOperation.createEagerIterator(this.queryDefinition);
        Map<Address, NodeTopDocs> topDocsResponses = this.broadcastQuery(command);
        return new DistributedIterator(this.queryStatistics, this.queryDefinition.getSearchQueryBuilder().getLuceneSort(), this.maxResults, this.resultSize, this.maxResults, this.firstResult, topDocsResponses, this.cache);
    }

    @Override
    public <K> CloseableIterator<Map.Entry<K, E>> entryIterator() {
        this.partitionHandlingSupport.checkCacheAvailable();
        this.queryDefinition.setMaxResults(this.getNodeMaxResults());
        ClusteredQueryOperation command = ClusteredQueryOperation.createEagerIterator(this.queryDefinition);
        Map<Address, NodeTopDocs> topDocsResponses = this.broadcastQuery(command);
        if (!this.queryDefinition.getSearchQueryBuilder().isEntityProjection()) {
            throw Log.CONTAINER.entryIteratorDoesNotAllowProjections();
        }
        return new DistributedEntryIterator(this.queryStatistics, this.queryDefinition.getSearchQueryBuilder().getLuceneSort(), this.maxResults, this.resultSize, this.maxResults, this.firstResult, topDocsResponses, this.cache);
    }

    private int getNodeMaxResults() {
        return this.maxResults + this.firstResult;
    }

    private Map<Address, NodeTopDocs> broadcastQuery(ClusteredQueryOperation command) {
        HashMap<Address, NodeTopDocs> topDocsResponses = new HashMap<Address, NodeTopDocs>();
        int resultSize = 0;
        List<QueryResponse> responses = this.invoker.broadcast(command);
        for (QueryResponse queryResponse : responses) {
            if (queryResponse.getNodeTopDocs().topDocs != null) {
                topDocsResponses.put(queryResponse.getNodeTopDocs().address, queryResponse.getNodeTopDocs());
            }
            resultSize = (int)((long)resultSize + queryResponse.getResultSize());
        }
        this.resultSize = resultSize;
        return topDocsResponses;
    }

    @Override
    public QueryResult<?> execute() {
        if (this.queryDefinition.getStatementType() != IckleParsingResult.StatementType.SELECT) {
            return new QueryResultImpl((long)this.executeStatement(), Collections.emptyList());
        }
        try {
            this.partitionHandlingSupport.checkCacheAvailable();
            List hits = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 0), false).collect(Collectors.toList());
            return new QueryResultImpl((long)this.resultSize.intValue(), hits);
        }
        catch (org.hibernate.search.util.common.SearchTimeoutException timeoutException) {
            throw new SearchTimeoutException();
        }
    }

    @Override
    public int executeStatement() {
        if (this.queryDefinition.getStatementType() != IckleParsingResult.StatementType.DELETE) {
            throw Log.CONTAINER.unsupportedStatement();
        }
        if (this.queryDefinition.getFirstResult() != 0 || this.queryDefinition.getMaxResults() != Integer.MAX_VALUE) {
            throw Log.CONTAINER.deleteStatementsCannotUsePaging();
        }
        try {
            this.partitionHandlingSupport.checkCacheAvailable();
            long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
            List<QueryResponse> responses = this.invoker.broadcast(ClusteredQueryOperation.delete(this.queryDefinition));
            int count = 0;
            for (QueryResponse response : responses) {
                count = (int)((long)count + response.getResultSize());
            }
            if (this.queryStatistics.isEnabled()) {
                this.recordQuery(System.nanoTime() - start);
            }
            return count;
        }
        catch (org.hibernate.search.util.common.SearchTimeoutException timeoutException) {
            throw new SearchTimeoutException();
        }
    }

    private void recordQuery(long nanos) {
        this.queryStatistics.distributedIndexedQueryExecuted(this.queryDefinition.getQueryString(), nanos);
    }

    @Override
    public IndexedQuery<E> timeout(long timeout, TimeUnit timeUnit) {
        this.queryDefinition.setTimeout(timeout, timeUnit);
        return this;
    }
}

