/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.util.function.SerializableFunction;

public final class QueryDefinition {
    private final SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>> queryEngineProvider;
    private final String queryString;
    private final IckleParsingResult.StatementType statementType;
    private SearchQueryBuilder searchQueryBuilder;
    private int maxResults = -1;
    private int firstResult = 0;
    private long timeout = -1L;
    private final Map<String, Object> namedParameters = new HashMap<String, Object>();

    public QueryDefinition(String queryString, IckleParsingResult.StatementType statementType, SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>> queryEngineProvider) {
        if (queryString == null) {
            throw new IllegalArgumentException("queryString cannot be null");
        }
        if (statementType == null) {
            throw new IllegalArgumentException("statementType cannot be null");
        }
        if (queryEngineProvider == null) {
            throw new IllegalArgumentException("queryEngineProvider cannot be null");
        }
        this.queryString = queryString;
        this.statementType = statementType;
        this.queryEngineProvider = queryEngineProvider;
    }

    public QueryDefinition(String queryString, IckleParsingResult.StatementType statementType, SearchQueryBuilder searchQueryBuilder) {
        if (queryString == null) {
            throw new IllegalArgumentException("queryString cannot be null");
        }
        if (statementType == null) {
            throw new IllegalArgumentException("statementType cannot be null");
        }
        if (searchQueryBuilder == null) {
            throw new IllegalArgumentException("searchQueryBuilder cannot be null");
        }
        this.searchQueryBuilder = searchQueryBuilder;
        this.queryString = queryString;
        this.statementType = statementType;
        this.queryEngineProvider = null;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public IckleParsingResult.StatementType getStatementType() {
        return this.statementType;
    }

    private QueryEngine<?> getQueryEngine(AdvancedCache<?, ?> cache) {
        if (this.queryEngineProvider == null) {
            throw new IllegalStateException("No query engine provider specified");
        }
        QueryEngine queryEngine = (QueryEngine)((Object)this.queryEngineProvider.apply(cache));
        if (queryEngine == null) {
            throw new IllegalStateException("The query engine provider could not locate a suitable query engine");
        }
        return queryEngine;
    }

    public void initialize(AdvancedCache<?, ?> cache) {
        if (this.searchQueryBuilder == null) {
            QueryEngine<?> queryEngine = this.getQueryEngine(cache);
            this.searchQueryBuilder = queryEngine.buildSearchQuery(this.queryString, this.namedParameters);
            if (this.timeout > 0L) {
                this.searchQueryBuilder.failAfter(this.timeout, TimeUnit.NANOSECONDS);
            }
        }
    }

    public SearchQueryBuilder getSearchQueryBuilder() {
        if (this.searchQueryBuilder == null) {
            throw new IllegalStateException("The QueryDefinition has not been initialized, make sure to call initialize(...) first");
        }
        return this.searchQueryBuilder;
    }

    public int getMaxResults() {
        return this.maxResults == -1 ? Integer.MAX_VALUE - this.getFirstResult() : this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setNamedParameters(Map<String, Object> params) {
        if (params == null) {
            this.namedParameters.clear();
        } else {
            this.namedParameters.putAll(params);
        }
    }

    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeUnit.toNanos(timeout);
        if (this.timeout > 0L && this.searchQueryBuilder != null) {
            this.searchQueryBuilder.failAfter(this.timeout, TimeUnit.NANOSECONDS);
        }
    }

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.getSearchQueryBuilder().failAfter(timeout, timeUnit);
    }

    public static final class Externalizer
    implements AdvancedExternalizer<QueryDefinition> {
        public Set<Class<? extends QueryDefinition>> getTypeClasses() {
            return Collections.singleton(QueryDefinition.class);
        }

        public Integer getId() {
            return ExternalizerIds.QUERY_DEFINITION;
        }

        public void writeObject(ObjectOutput output, QueryDefinition queryDefinition) throws IOException {
            output.writeUTF(queryDefinition.queryString);
            output.writeByte(queryDefinition.statementType.ordinal());
            output.writeObject(queryDefinition.queryEngineProvider);
            output.writeInt(queryDefinition.firstResult);
            output.writeInt(queryDefinition.maxResults);
            output.writeLong(queryDefinition.timeout);
            Map<String, Object> namedParameters = queryDefinition.namedParameters;
            int paramSize = namedParameters.size();
            output.writeShort(paramSize);
            if (paramSize != 0) {
                for (Map.Entry<String, Object> param : namedParameters.entrySet()) {
                    output.writeUTF(param.getKey());
                    output.writeObject(param.getValue());
                }
            }
        }

        public QueryDefinition readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String queryString = input.readUTF();
            IckleParsingResult.StatementType statementType = IckleParsingResult.StatementType.valueOf((int)input.readByte());
            SerializableFunction queryEngineProvider = (SerializableFunction)input.readObject();
            QueryDefinition queryDefinition = new QueryDefinition(queryString, statementType, queryEngineProvider);
            queryDefinition.setFirstResult(input.readInt());
            queryDefinition.setMaxResults(input.readInt());
            queryDefinition.timeout = input.readLong();
            int paramSize = input.readShort();
            if (paramSize != 0) {
                HashMap<String, Object> params = new HashMap<String, Object>(paramSize);
                for (int i = 0; i < paramSize; ++i) {
                    String key = input.readUTF();
                    Object value = input.readObject();
                    params.put(key, value);
                }
                queryDefinition.setNamedParameters(params);
            }
            return queryDefinition;
        }
    }
}

