/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.infinispan.Cache;
import org.infinispan.query.QueryIterator;
import org.infinispan.query.impl.EagerIterator;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class EagerIteratorTest {
    List<Object> keys;
    Map<String, String> dummyResults;
    QueryIterator iterator;
    int fetchSize = 1;
    Cache<String, String> cache;

    @BeforeMethod
    public void setUp() throws Exception {
        this.keys = new ArrayList<Object>();
        this.dummyResults = new HashMap<String, String>();
        for (int i = 1; i <= 10; ++i) {
            String key = "key" + i;
            this.keys.add(key);
            this.dummyResults.put(key, "Result number " + i);
        }
        this.cache = (Cache)EasyMock.createMock(Cache.class);
        EasyMock.expect((Object)this.cache.get(EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<String>(){

            public String answer() throws Throwable {
                String k = EasyMock.getCurrentArguments()[0].toString();
                return EagerIteratorTest.this.dummyResults.get(k);
            }
        }).anyTimes();
        this.iterator = new EagerIterator(this.keys, this.cache, this.fetchSize);
        EasyMock.replay((Object[])new Object[]{this.cache});
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.keys = null;
        this.dummyResults = null;
        this.iterator = null;
    }

    public void testJumpToResult() throws IndexOutOfBoundsException {
        this.iterator.jumpToResult(0);
        assert (this.iterator.isFirst());
        this.iterator.jumpToResult(1);
        assert (this.iterator.isAfterFirst());
        this.iterator.jumpToResult(this.keys.size() - 1);
        assert (this.iterator.isLast());
        this.iterator.jumpToResult(this.keys.size() - 2);
        assert (this.iterator.isBeforeLast());
    }

    public void testFirst() {
        assert (this.iterator.isFirst()) : "We should be pointing at the first element";
        Object next = this.iterator.next();
        System.out.println(next);
        assert (next == this.dummyResults.get(this.keys.get(0)));
        assert (!this.iterator.isFirst());
        this.iterator.first();
        assert (this.iterator.isFirst()) : "We should be pointing at the first element";
        next = this.iterator.next();
        assert (next == this.dummyResults.get(this.keys.get(0)));
        assert (!this.iterator.isFirst());
    }

    public void testLast() {
        this.iterator.last();
        assert (this.iterator.isLast());
        Object next = this.iterator.next();
        int size = this.keys.size();
        assert (next == this.dummyResults.get(this.keys.get(size - 1)));
        assert (!this.iterator.isLast());
    }

    public void testAfterFirst() {
        this.iterator.afterFirst();
        assert (this.iterator.isAfterFirst());
        Object previous = this.iterator.previous();
        assert (previous == this.dummyResults.get(this.keys.get(1)));
        assert (!this.iterator.isAfterFirst());
    }

    public void testBeforeLast() {
        this.iterator.beforeLast();
        assert (this.iterator.isBeforeLast());
        Object next = this.iterator.next();
        int size = this.keys.size();
        assert (next == this.dummyResults.get(this.keys.get(size - 2)));
        assert (!this.iterator.isBeforeLast());
    }

    public void testIsFirst() {
        this.iterator.first();
        assert (this.iterator.isFirst());
        this.iterator.next();
        assert (!this.iterator.isFirst());
    }

    public void testIsLast() {
        this.iterator.last();
        assert (this.iterator.isLast());
        this.iterator.previous();
        assert (!this.iterator.isLast());
    }

    public void testIsAfterFirst() {
        this.iterator.afterFirst();
        assert (this.iterator.isAfterFirst());
        this.iterator.previous();
        assert (!this.iterator.isAfterFirst());
    }

    public void testIsBeforeLast() {
        this.iterator.beforeLast();
        assert (this.iterator.isBeforeLast());
    }

    public void testNextAndHasNext() {
        this.iterator.first();
        for (int i = 0; i < this.keys.size(); ++i) {
            System.out.println("Loop number count: - " + (i + 1));
            String expectedValue = this.dummyResults.get(this.keys.get(i));
            assert (this.iterator.hasNext());
            assert (expectedValue == this.iterator.next());
        }
        assert (!this.iterator.hasNext());
    }

    public void testPreviousAndHasPrevious() {
        this.iterator.last();
        for (int i = this.keys.size() - 1; i >= 0; --i) {
            String expectedValue = this.dummyResults.get(this.keys.get(i));
            assert (this.iterator.hasPrevious());
            assert (expectedValue == this.iterator.previous());
        }
        assert (!this.iterator.hasPrevious());
    }

    public void testNextIndex() {
        this.iterator.first();
        assert (this.iterator.nextIndex() == 1);
        this.iterator.last();
        assert (this.iterator.nextIndex() == this.keys.size());
    }

    public void testPreviousIndex() {
        this.iterator.first();
        assert (this.iterator.previousIndex() == -1);
        this.iterator.last();
        assert (this.iterator.previousIndex() == this.keys.size() - 2);
    }
}

