/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.easymock.IAnswer;
import org.easymock.classextension.EasyMock;
import org.hibernate.search.engine.DocumentExtractor;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.infinispan.Cache;
import org.infinispan.query.impl.LazyIterator;
import org.infinispan.query.test.Person;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class LazyIteratorTest {
    Cache<String, Person> cache;
    LazyIterator iterator = null;
    int fetchSize = 1;
    Person person1;
    Person person2;
    Person person3;
    Person person4;
    Person person5;
    Person person6;
    Person person7;
    Person person8;
    Person person9;
    Person person10;
    StringBuilder builder;
    Map<String, Person> dummyDataMap;
    List<String> keyList;

    @BeforeTest
    public void setUpBeforeTest() throws Exception {
        this.dummyDataMap = new HashMap<String, Person>();
        this.person1 = new Person();
        this.person2 = new Person();
        this.person3 = new Person();
        this.person4 = new Person();
        this.person5 = new Person();
        this.person6 = new Person();
        this.person7 = new Person();
        this.person8 = new Person();
        this.person9 = new Person();
        this.person10 = new Person();
        this.person1.setBlurb("cat");
        this.person2.setBlurb("cat");
        this.person3.setBlurb("cat");
        this.person4.setBlurb("cat");
        this.person5.setBlurb("cat");
        this.person6.setBlurb("cat");
        this.person7.setBlurb("cat");
        this.person8.setBlurb("cat");
        this.person9.setBlurb("cat");
        this.person10.setBlurb("cat");
        this.dummyDataMap.put("key1", this.person1);
        this.dummyDataMap.put("key2", this.person2);
        this.dummyDataMap.put("key3", this.person3);
        this.dummyDataMap.put("key4", this.person4);
        this.dummyDataMap.put("key5", this.person5);
        this.dummyDataMap.put("key6", this.person6);
        this.dummyDataMap.put("key7", this.person7);
        this.dummyDataMap.put("key8", this.person8);
        this.dummyDataMap.put("key9", this.person9);
        this.dummyDataMap.put("key10", this.person10);
        this.keyList = new ArrayList<String>();
        this.keyList.add("key1");
        this.keyList.add("key2");
        this.keyList.add("key3");
        this.keyList.add("key4");
        this.keyList.add("key5");
        this.keyList.add("key6");
        this.keyList.add("key7");
        this.keyList.add("key8");
        this.keyList.add("key9");
        this.keyList.add("key10");
    }

    @BeforeMethod
    public void setUp() throws ParseException {
        this.cache = (Cache)org.easymock.EasyMock.createMock(Cache.class);
        org.easymock.EasyMock.expect((Object)this.cache.get(org.easymock.EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Person>(){

            public Person answer() throws Throwable {
                String key = org.easymock.EasyMock.getCurrentArguments()[0].toString();
                return LazyIteratorTest.this.dummyDataMap.get(key);
            }
        }).anyTimes();
        SearchFactoryImplementor searchFactory = (SearchFactoryImplementor)org.easymock.EasyMock.createMock(SearchFactoryImplementor.class);
        DocumentExtractor extractor = (DocumentExtractor)EasyMock.createMock(DocumentExtractor.class);
        try {
            EasyMock.expect((Object)extractor.extract(org.easymock.EasyMock.anyInt())).andAnswer((IAnswer)new IAnswer<EntityInfo>(){

                public EntityInfo answer() throws Throwable {
                    int index = (Integer)org.easymock.EasyMock.getCurrentArguments()[0];
                    String keyString = LazyIteratorTest.this.keyList.get(index);
                    return new EntityInfo(Person.class, (Serializable)((Object)keyString), null);
                }
            }).anyTimes();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IndexSearcher searcher = (IndexSearcher)EasyMock.createMock(IndexSearcher.class);
        org.easymock.EasyMock.replay((Object[])new Object[]{this.cache, searchFactory});
        EasyMock.replay((Object[])new Object[]{searcher, extractor});
        this.iterator = new LazyIterator(extractor, this.cache, searcher, searchFactory, 0, 9, this.fetchSize);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.iterator = null;
    }

    public void testJumpToResult() throws IndexOutOfBoundsException {
        this.iterator.jumpToResult(0);
        assert (this.iterator.isFirst());
        this.iterator.jumpToResult(1);
        assert (this.iterator.isAfterFirst());
        this.iterator.jumpToResult(9);
        assert (this.iterator.isLast());
        this.iterator.jumpToResult(8);
        assert (this.iterator.isBeforeLast());
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testOutOfBoundsBelow() {
        this.iterator.jumpToResult(-1);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testOutOfBoundsAbove() {
        this.iterator.jumpToResult(this.keyList.size() + 1);
    }

    public void testFirst() {
        assert (this.iterator.isFirst()) : "We should be pointing at the first element";
        Object next = this.iterator.next();
        System.out.println(next);
        assert (next == this.person1);
        assert (!this.iterator.isFirst());
        this.iterator.first();
        assert (this.iterator.isFirst()) : "We should be pointing at the first element";
        next = this.iterator.next();
        assert (next == this.person1);
        assert (!this.iterator.isFirst());
    }

    public void testLast() {
        this.iterator.last();
        assert (this.iterator.isLast());
        this.iterator.first();
        assert (!this.iterator.isLast());
    }

    public void testAfterFirst() {
        this.iterator.afterFirst();
        assert (this.iterator.isAfterFirst());
        Object previous = this.iterator.previous();
        assert (previous == this.person2);
        assert (!this.iterator.isAfterFirst());
    }

    public void testBeforeLast() {
        this.iterator.beforeLast();
        assert (this.iterator.isBeforeLast());
        Object next = this.iterator.next();
        assert (next == this.person9);
        assert (!this.iterator.isBeforeLast());
    }

    public void testIsFirst() {
        this.iterator.first();
        assert (this.iterator.isFirst());
        this.iterator.next();
        assert (!this.iterator.isFirst());
    }

    public void testIsLast() {
        this.iterator.last();
        assert (this.iterator.isLast());
        this.iterator.previous();
        assert (!this.iterator.isLast());
    }

    public void testIsAfterFirst() {
        this.iterator.afterFirst();
        assert (this.iterator.isAfterFirst());
        this.iterator.previous();
        assert (!this.iterator.isAfterFirst());
    }

    public void testIsBeforeLast() {
        this.iterator.beforeLast();
        assert (this.iterator.isBeforeLast());
    }

    public void testNextAndHasNext() {
        this.iterator.first();
        this.builder = new StringBuilder();
        for (int i = 1; i <= 10; ++i) {
            this.builder.delete(0, 4);
            this.builder.append("key");
            this.builder.append(i);
            String keyString = this.builder.toString();
            Object expectedValue = this.cache.get((Object)keyString);
            assert (this.iterator.hasNext());
            Object next = this.iterator.next();
            assert (expectedValue == next);
        }
        assert (!this.iterator.hasNext());
    }

    public void testPreviousAndHasPrevious() {
        this.iterator.last();
        this.builder = new StringBuilder();
        for (int i = 10; i >= 1; --i) {
            this.builder.delete(0, 5);
            this.builder.append("key");
            this.builder.append(i);
            String keyString = this.builder.toString();
            Object expectedValue = this.cache.get((Object)keyString);
            assert (this.iterator.hasPrevious());
            Object previous = this.iterator.previous();
            assert (expectedValue == previous);
        }
        assert (!this.iterator.hasPrevious());
    }

    public void testNextIndex() {
        this.iterator.first();
        assert (this.iterator.nextIndex() == 1);
        this.iterator.last();
        assert (this.iterator.nextIndex() == 10);
    }

    public void testPreviousIndex() {
        this.iterator.first();
        assert (this.iterator.previousIndex() == -1);
        this.iterator.last();
        assert (this.iterator.previousIndex() == 8);
    }
}

