/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Map;
import javax.transaction.TransactionManager;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.query.backend.QueryInterceptor;

public class LocalQueryInterceptor
extends QueryInterceptor {
    @Override
    @Inject
    public void init(SearchFactoryImplementor searchFactory, TransactionManager transactionManager) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entered LocalQueryInterceptor.init()");
        }
        this.searchFactory = searchFactory;
        this.transactionManager = transactionManager;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entered the LocalQueryInterceptor visitPutKeyValueCommand()");
        }
        Object toReturn = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        Object value = this.checkForMarshalledValue(command.getValue());
        if (ctx.isOriginLocal()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Origin is local");
            }
            this.addToIndexes(value, this.checkForMarshalledValue(command.getKey()).toString());
        }
        return toReturn;
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entered the LocalQueryInterceptor visitRemoveCommand()");
        }
        Object valueRemoved = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (command.isSuccessful() && ctx.isOriginLocal()) {
            this.log.debug((Object)"Origin is local");
            this.removeFromIndexes(this.checkForMarshalledValue(valueRemoved), this.checkForMarshalledValue(command.getKey()).toString());
        }
        return valueRemoved;
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object valueReplaced;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entered the LocalQueryInterceptor visitReplaceCommand()");
        }
        if ((valueReplaced = this.invokeNextInterceptor(ctx, (VisitableCommand)command)) != null && ctx.isOriginLocal()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Origin is local");
            }
            Object[] parameters = command.getParameters();
            String keyString = this.checkForMarshalledValue(command.getKey()).toString();
            this.removeFromIndexes(this.checkForMarshalledValue(parameters[1]), keyString);
            this.addToIndexes(this.checkForMarshalledValue(parameters[2]), keyString);
        }
        return valueReplaced;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entered LocalQueryInterceptor visitPutMapCommand()");
        }
        Object mapPut = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (ctx.isOriginLocal()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Origin is local");
            }
            Map dataMap = command.getMap();
            for (Map.Entry entry : dataMap.entrySet()) {
                this.addToIndexes(entry.getValue(), entry.getKey().toString());
            }
        }
        return mapPut;
    }
}

