/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Properties;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.impl.SearchFactoryImpl;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.InterceptorChainFactory;
import org.infinispan.interceptors.LockingInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.query.backend.LocalQueryInterceptor;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.backend.SearchableCacheConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class QueryHelper {
    public static final String QUERY_ENABLED_PROPERTY = "infinispan.query.enabled";
    public static final String QUERY_INDEX_LOCAL_ONLY_PROPERTY = "infinispan.query.indexLocalOnly";
    private Cache cache;
    private Properties properties;
    private Class[] classes;
    private SearchFactoryImplementor searchFactory;
    Log log = LogFactory.getLog(this.getClass());

    public QueryHelper(Cache cache, Properties properties, Class ... classes) {
        if (cache.getStatus().needToInitializeBeforeStart()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Cache not started.  Starting cache first.");
            }
            cache.start();
        }
        this.checkInterceptorChain(cache);
        if (classes.length == 0) {
            throw new IllegalArgumentException("You haven't passed in any classes to index.");
        }
        this.validateClasses(classes);
        if (properties == null) {
            this.log.debug((Object)"Properties is null.");
        }
        this.cache = cache;
        this.properties = properties;
        this.classes = classes;
        SearchableCacheConfiguration cfg = new SearchableCacheConfiguration(classes, properties);
        this.searchFactory = new SearchFactoryImpl((SearchConfiguration)cfg);
        this.applyProperties();
    }

    private void applyProperties() {
        boolean query;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entered QueryHelper.applyProperties()");
        }
        if (query = Boolean.getBoolean(QUERY_ENABLED_PROPERTY)) {
            boolean indexLocal = Boolean.getBoolean(QUERY_INDEX_LOCAL_ONLY_PROPERTY);
            try {
                if (indexLocal) {
                    this.addInterceptor(LocalQueryInterceptor.class);
                } else {
                    this.addInterceptor(QueryInterceptor.class);
                }
            }
            catch (Exception e) {
                throw new CacheException("Unable to add interceptor", (Throwable)e);
            }
        }
    }

    public SearchFactoryImplementor getSearchFactory() {
        return this.searchFactory;
    }

    public Class[] getClasses() {
        return this.classes;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void addInterceptor(Class<? extends QueryInterceptor> interceptorClass) throws IllegalAccessException, InstantiationException {
        ComponentRegistry cr = this.cache.getAdvancedCache().getComponentRegistry();
        cr.registerComponent((Object)this.searchFactory, SearchFactoryImplementor.class);
        InterceptorChainFactory icf = (InterceptorChainFactory)cr.getComponent(InterceptorChainFactory.class);
        CommandInterceptor inter = icf.createInterceptor(interceptorClass);
        cr.registerComponent((Object)inter, QueryInterceptor.class);
        this.cache.getAdvancedCache().addInterceptorAfter(inter, LockingInterceptor.class);
    }

    private void validateClasses(Class ... classes) {
        for (Class c : classes) {
            if (!c.isAnnotationPresent(ProvidedId.class)) {
                throw new IllegalArgumentException("There is no provided id on " + c.getName() + " class");
            }
            for (Field field : c.getFields()) {
                if (field.getAnnotation(DocumentId.class) == null) continue;
                throw new IllegalArgumentException("Please remove the documentId annotation in " + c.getName());
            }
            for (Field field : c.getDeclaredFields()) {
                if (field.getAnnotation(DocumentId.class) == null) continue;
                throw new IllegalArgumentException("Please remove the documentId annotation in " + c.getName());
            }
        }
    }

    private void checkInterceptorChain(Cache cache) {
        AdvancedCache advanced = cache.getAdvancedCache();
        List interceptorList = advanced.getInterceptorChain();
        for (CommandInterceptor inter : interceptorList) {
            if (!inter.getClass().equals(QueryInterceptor.class) && !inter.getClass().equals(LocalQueryInterceptor.class)) continue;
            throw new CacheException("There is already an instance of the QueryInterceptor running");
        }
    }
}

