/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.io.Serializable;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.query.backend.TransactionalEventTransactionContext;

public class QueryInterceptor
extends CommandInterceptor {
    protected SearchFactoryImplementor searchFactory;
    protected TransactionManager transactionManager;

    @Inject
    public void init(SearchFactoryImplementor searchFactory, TransactionManager transactionManager) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entered QueryInterceptor.init()");
        }
        this.searchFactory = searchFactory;
        this.transactionManager = transactionManager;
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entered the searchable core interceptor visitPutKeyValueCommand()");
        }
        Object toReturn = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        this.addToIndexes(this.checkForMarshalledValue(command.getValue()), this.checkForMarshalledValue(command.getKey()).toString());
        return toReturn;
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entered the searchable core interceptor visitRemoveCommand()");
        }
        Object valueRemoved = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Transaction Manager is " + this.transactionManager));
        }
        if (command.isSuccessful()) {
            this.removeFromIndexes(this.checkForMarshalledValue(valueRemoved), this.checkForMarshalledValue(command.getKey()).toString());
        }
        return valueRemoved;
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object valueReplaced;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entered the searchable core interceptor visitReplaceCommand()");
        }
        if ((valueReplaced = this.invokeNextInterceptor(ctx, (VisitableCommand)command)) != null) {
            Object[] parameters = command.getParameters();
            String keyString = this.checkForMarshalledValue(command.getKey()).toString();
            this.removeFromIndexes(this.checkForMarshalledValue(parameters[1]), keyString);
            this.addToIndexes(this.checkForMarshalledValue(parameters[2]), keyString);
        }
        return valueReplaced;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entered searchable core interceptor visitPutMapCommand()");
        }
        Object mapPut = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        Map dataMap = command.getMap();
        for (Map.Entry entry : dataMap.entrySet()) {
            this.addToIndexes(this.checkForMarshalledValue(entry.getValue()), this.checkForMarshalledValue(entry.getKey()).toString());
        }
        return mapPut;
    }

    protected void addToIndexes(Object value, String key) {
        TransactionalEventTransactionContext transactionContext = new TransactionalEventTransactionContext(this.transactionManager);
        this.searchFactory.getWorker().performWork(new Work(value, (Serializable)((Object)key), WorkType.ADD), (TransactionContext)transactionContext);
    }

    protected void removeFromIndexes(Object value, String key) {
        TransactionalEventTransactionContext transactionContext = new TransactionalEventTransactionContext(this.transactionManager);
        this.searchFactory.getWorker().performWork(new Work(value, (Serializable)((Object)key), WorkType.DELETE), (TransactionContext)transactionContext);
    }

    protected Object checkForMarshalledValue(Object o) {
        if (o instanceof MarshalledValue) {
            return ((MarshalledValue)o).get();
        }
        return o;
    }
}

