/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.List;
import java.util.Properties;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.QueryFactory;
import org.infinispan.query.backend.QueryHelper;
import org.infinispan.query.test.CustomKey;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class KeyTypeTest
extends SingleCacheManagerTest {
    Cache<Object, Person> cache;
    QueryHelper qh;
    Person person1;

    protected CacheManager createCacheManager() throws Exception {
        Configuration c = this.getDefaultClusteredConfig(Configuration.CacheMode.LOCAL, true);
        c.setIndexingEnabled(true);
        c.setIndexLocalOnly(false);
        return TestCacheManagerFactory.createCacheManager((Configuration)c, (boolean)true);
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        CacheManager manager = this.createCacheManager();
        this.cache = manager.getCache();
        this.qh = new QueryHelper(this.cache, new Properties(), new Class[]{Person.class});
        this.person1 = new Person();
        this.person1.setName("Navin");
        this.person1.setBlurb("Owns a macbook");
        this.person1.setAge(20);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache != null) {
            this.cache.clear();
            this.cache.stop();
        }
    }

    public void testPrimitiveAndStringKeys() {
        String key1 = "key1";
        int key2 = 2;
        byte key3 = 3;
        float key4 = 4.0f;
        long key5 = 5L;
        short key6 = 6;
        boolean key7 = true;
        double key8 = 8.0;
        char key9 = '9';
        this.cache.put((Object)key1, (Object)this.person1);
        this.cache.put((Object)key2, (Object)this.person1);
        this.cache.put((Object)key3, (Object)this.person1);
        this.cache.put((Object)Float.valueOf(key4), (Object)this.person1);
        this.cache.put((Object)key5, (Object)this.person1);
        this.cache.put((Object)key6, (Object)this.person1);
        this.cache.put((Object)key7, (Object)this.person1);
        this.cache.put((Object)key8, (Object)this.person1);
        this.cache.put((Object)Character.valueOf(key9), (Object)this.person1);
        Term term = new Term("blurb", "owns");
        CacheQuery cacheQuery = new QueryFactory(this.cache, this.qh).getQuery((Query)new TermQuery(term));
        assert (cacheQuery.getResultSize() == 9);
        List found = cacheQuery.list();
        for (int i = 0; i < 9; ++i) {
            assert (found.get(i).equals(this.person1));
        }
    }

    public void testCustomKeys() {
        CustomKey key1 = new CustomKey(1, 2, 3);
        CustomKey key2 = new CustomKey(900, 800, 700);
        CustomKey key3 = new CustomKey(1024, 2048, 4096);
        this.cache.put((Object)key1, (Object)this.person1);
        this.cache.put((Object)key2, (Object)this.person1);
        this.cache.put((Object)key3, (Object)this.person1);
        Term term = new Term("blurb", "owns");
        CacheQuery cacheQuery = new QueryFactory(this.cache, this.qh).getQuery((Query)new TermQuery(term));
        assert (cacheQuery.getResultSize() == 3);
    }
}

