/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.lucene.queryParser.ParseException;
import org.infinispan.manager.CacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.QueryFactory;
import org.infinispan.query.backend.QueryHelper;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(testName="query.config.DeclarativeConfigTest", groups={"functional"})
public class DeclarativeConfigTest
extends SingleCacheManagerTest {
    QueryFactory qf;

    protected CacheManager createCacheManager() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:4.0 http://www.infinispan.org/schemas/infinispan-config-4.0.xsd\"\n      xmlns=\"urn:infinispan:config:4.0\">   <default>\n      <indexing enabled=\"true\" indexLocalOnly=\"true\"/>\n   </default>\n</infinispan>";
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.cacheManager = TestCacheManagerFactory.fromStream((InputStream)is);
        this.cache = this.cacheManager.getCache();
        QueryHelper qh = TestQueryHelperFactory.createTestQueryHelperInstance(this.cache, Person.class);
        this.qf = new QueryFactory(this.cache, qh);
        return this.cacheManager;
    }

    public void simpleIndexTest() throws ParseException {
        this.cache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        CacheQuery cq = this.qf.getBasicQuery("name", "Person");
        assert (cq.getResultSize() == 1);
        List l = cq.list();
        assert (l.size() == 1);
        Person p = (Person)l.get(0);
        assert (p.getName().equals("A Person's Name"));
        assert (p.getBlurb().equals("A paragraph containing some text"));
        assert (p.getAge() == 75);
    }
}

