/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.tx;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.ProvidedId;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.QueryFactory;
import org.infinispan.query.backend.QueryHelper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.tx.TransactionalQueryTest")
public class TransactionalQueryTest
extends SingleCacheManagerTest {
    protected CacheManager m_cacheManager;
    private QueryHelper m_queryHelper;
    private Cache<String, Session> m_cache;
    private TransactionManager m_transactionManager;

    protected CacheManager createCacheManager() throws Exception {
        Configuration c = this.getDefaultStandaloneConfig(true);
        c.setIndexingEnabled(true);
        c.setIndexLocalOnly(true);
        this.m_cacheManager = TestCacheManagerFactory.createCacheManager((Configuration)c, (boolean)true);
        this.m_cache = this.m_cacheManager.getCache();
        this.m_transactionManager = this.m_cache.getAdvancedCache().getTransactionManager();
        return this.m_cacheManager;
    }

    @BeforeMethod
    public void initialize() {
        try {
            Properties properties = new Properties();
            properties.put("hibernate.search.default.directory_provider", "org.hibernate.search.store.RAMDirectoryProvider");
            this.m_queryHelper = new QueryHelper(this.m_cache, properties, new Class[]{Session.class});
            this.m_transactionManager.begin();
            for (int i = 0; i < 100; ++i) {
                this.m_cache.put((Object)String.valueOf(i), (Object)new Session(String.valueOf(i)));
            }
            this.m_transactionManager.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() {
        try {
            QueryFactory queryFactory = new QueryFactory(this.m_cache, this.m_queryHelper);
            CacheQuery cacheQuery = queryFactory.getBasicQuery("", "Id:2?");
            System.out.println("Hits: " + cacheQuery.getResultSize());
            this.m_transactionManager.begin();
            this.m_cache.remove((Object)"50");
            this.m_transactionManager.commit();
            this.m_transactionManager.begin();
            this.m_cache.remove((Object)"200");
            this.m_transactionManager.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ProvidedId
    @Indexed(index="SessionIndex")
    public class Session {
        private String m_id;

        public Session(String id) {
            this.m_id = id;
        }

        @Field(name="Id")
        public String getId() {
            return this.m_id;
        }
    }
}

