/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.test.CustomKey;
import org.infinispan.query.test.CustomKey2;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class KeyTransformationHandlerTest {
    String s = null;
    Object key = null;

    public void testKeyToStringWithStringAndPrimitives() {
        this.s = KeyTransformationHandler.keyToString((Object)"key");
        assert (this.s.equals("S:key"));
        this.s = KeyTransformationHandler.keyToString((Object)1);
        assert (this.s.equals("I:1"));
        this.s = KeyTransformationHandler.keyToString((Object)true);
        assert (this.s.equals("B:true"));
        this.s = KeyTransformationHandler.keyToString((Object)1);
        assert (this.s.equals("X:1"));
        this.s = KeyTransformationHandler.keyToString((Object)1L);
        assert (this.s.equals("L:1"));
        this.s = KeyTransformationHandler.keyToString((Object)1);
        assert (this.s.equals("Y:1"));
        this.s = KeyTransformationHandler.keyToString((Object)Float.valueOf(1.0f));
        assert (this.s.equals("F:1.0"));
        this.s = KeyTransformationHandler.keyToString((Object)Character.valueOf('A'));
        assert (this.s.equals("C:A"));
        this.s = KeyTransformationHandler.keyToString((Object)1.0);
        assert (this.s.equals("D:1.0"));
    }

    public void testStringToKeyWithStringAndPrimitives() {
        this.key = KeyTransformationHandler.stringToKey((String)"S:key1");
        assert (this.key.getClass().equals(String.class));
        assert (this.key.equals("key1"));
        this.key = KeyTransformationHandler.stringToKey((String)"I:2");
        assert (this.key.getClass().equals(Integer.class));
        assert (this.key.equals(2));
        this.key = KeyTransformationHandler.stringToKey((String)"Y:3");
        assert (this.key.getClass().equals(Byte.class));
        assert (this.key.equals((byte)3));
        this.key = KeyTransformationHandler.stringToKey((String)"F:4.0");
        assert (this.key.getClass().equals(Float.class));
        assert (this.key.equals(Float.valueOf(4.0f)));
        this.key = KeyTransformationHandler.stringToKey((String)"L:5");
        assert (this.key.getClass().equals(Long.class));
        assert (this.key.equals(5L));
        this.key = KeyTransformationHandler.stringToKey((String)"X:6");
        assert (this.key.getClass().equals(Short.class));
        assert (this.key.equals((short)6));
        this.key = KeyTransformationHandler.stringToKey((String)"B:true");
        assert (this.key.getClass().equals(Boolean.class));
        assert (this.key.equals(true));
        this.key = KeyTransformationHandler.stringToKey((String)"D:8.0");
        assert (this.key.getClass().equals(Double.class));
        assert (this.key.equals(8.0));
        this.key = KeyTransformationHandler.stringToKey((String)"C:9");
        assert (this.key.getClass().equals(Character.class));
        assert (this.key.equals(Character.valueOf('9')));
    }

    public void testStringToKeyWithCustomTransformable() {
        CustomKey customKey = new CustomKey(88, 8800, 12889976);
        String strRep = KeyTransformationHandler.keyToString((Object)customKey);
        assert (customKey.equals(KeyTransformationHandler.stringToKey((String)strRep)));
    }

    public void testStringToKeyWithDefaultTransformer() {
        CustomKey2 ck2 = new CustomKey2(Integer.MAX_VALUE, Integer.MIN_VALUE, 0);
        String strRep = KeyTransformationHandler.keyToString((Object)ck2);
        assert (ck2.equals(KeyTransformationHandler.stringToKey((String)strRep)));
    }
}

