/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.infinispan.Cache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.QueryFactory;
import org.infinispan.query.QueryIterator;
import org.infinispan.query.backend.QueryHelper;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.testng.annotations.AfterMethod;

public abstract class AbstractLocalQueryTest
extends SingleCacheManagerTest {
    protected Person person1;
    protected Person person2;
    protected Person person3;
    protected Person person4;
    protected Person person5;
    protected Person person6;
    protected QueryParser queryParser;
    protected Query luceneQuery;
    protected CacheQuery cacheQuery;
    protected List found;
    protected String key1 = "Navin";
    protected String key2 = "BigGoat";
    protected String key3 = "MiniGoat";
    protected Cache<Object, Person> cache;
    protected QueryHelper qh;

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache != null) {
            this.cache.stop();
        }
    }

    public void testSimple() throws ParseException {
        this.cacheQuery = new QueryFactory(this.cache, this.qh).getBasicQuery("blurb", "playing");
        this.found = this.cacheQuery.list();
        int elems = this.found.size();
        assert (elems == 1) : "Expected 1 but was " + elems;
        Object val = this.found.get(0);
        assert (val.equals(this.person1)) : "Expected " + this.person1 + " but was " + val;
    }

    public void testEagerIterator() throws ParseException {
        this.cacheQuery = new QueryFactory(this.cache, this.qh).getBasicQuery("blurb", "playing");
        QueryIterator found = this.cacheQuery.iterator();
        assert (found.isFirst());
        assert (found.isLast());
    }

    public void testMultipleResults() throws ParseException {
        this.queryParser = new QueryParser("name", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("goat");
        this.cacheQuery = new QueryFactory(this.cache, this.qh).getQuery(this.luceneQuery);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 2);
        assert (this.found.get(0) == this.person2);
        assert (this.found.get(1) == this.person3);
    }

    public void testModified() throws ParseException {
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = new QueryFactory(this.cache, this.qh).getQuery(this.luceneQuery);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1);
        assert (this.found.get(0).equals(this.person1));
        this.person1.setBlurb("Likes pizza");
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("pizza");
        this.cacheQuery = new QueryFactory(this.cache, this.qh).getQuery(this.luceneQuery);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1);
        assert (this.found.get(0).equals(this.person1));
    }

    public void testAdded() throws ParseException {
        this.queryParser = new QueryParser("name", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("Goat");
        this.cacheQuery = new QueryFactory(this.cache, this.qh).getQuery(this.luceneQuery);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 2) : "Size of list should be 2";
        assert (this.found.contains(this.person2));
        assert (this.found.contains(this.person3));
        assert (!this.found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.cache.put((Object)"mighty", (Object)this.person4);
        this.luceneQuery = this.queryParser.parse("Goat");
        this.cacheQuery = new QueryFactory(this.cache, this.qh).getQuery(this.luceneQuery);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 3) : "Size of list should be 3";
        assert (this.found.contains(this.person2));
        assert (this.found.contains(this.person3));
        assert (this.found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testRemoved() throws ParseException {
        this.queryParser = new QueryParser("name", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("Goat");
        this.cacheQuery = new QueryFactory(this.cache, this.qh).getQuery(this.luceneQuery);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 2);
        assert (this.found.contains(this.person2));
        assert (this.found.contains(this.person3)) : "This should still contain object person3";
        this.cache.remove((Object)this.key3);
        this.luceneQuery = this.queryParser.parse("Goat");
        this.cacheQuery = new QueryFactory(this.cache, this.qh).getQuery(this.luceneQuery);
        this.found = this.cacheQuery.list();
        System.out.println("found is: - " + this.found);
        assert (this.found.size() == 1);
        assert (this.found.contains(this.person2));
        assert (!this.found.contains(this.person3)) : "The search should not return person3";
    }

    public void testSetSort() throws ParseException {
        this.person2.setAge(35);
        this.person3.setAge(12);
        Sort sort = new Sort("age");
        this.queryParser = new QueryParser("name", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("Goat");
        this.cacheQuery = new QueryFactory(this.cache, this.qh).getQuery(this.luceneQuery);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 2);
        this.cacheQuery.setSort(sort);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 2);
        assert (this.found.get(0).equals(this.person2));
        assert (this.found.get(1).equals(this.person3));
    }

    public void testSetFilter() throws ParseException {
        this.queryParser = new QueryParser("name", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("goat");
        this.cacheQuery = new QueryFactory(this.cache, this.qh).getQuery(this.luceneQuery);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 2);
        PrefixFilter filter = new PrefixFilter(new Term("blurb", "cheese"));
        this.cacheQuery.setFilter((Filter)filter);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1);
    }

    public void testLazyIterator() throws ParseException {
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = new QueryFactory(this.cache, this.qh).getQuery(this.luceneQuery);
        QueryIterator found = this.cacheQuery.lazyIterator();
        assert (found.isFirst());
        assert (found.isLast());
    }

    public void testGetResultSize() throws ParseException {
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = new QueryFactory(this.cache, this.qh).getQuery(this.luceneQuery);
        assert (this.cacheQuery.getResultSize() == 1);
    }

    public void testClear() throws ParseException {
        Term navin = new Term("name", "navin");
        Term goat = new Term("name", "goat");
        Query[] queries = new Query[]{new TermQuery(goat), new TermQuery(navin)};
        this.luceneQuery = queries[0].combine(queries);
        this.cacheQuery = new QueryFactory(this.cache, this.qh).getQuery(this.luceneQuery);
        assert (this.cacheQuery.getResultSize() == 3);
        this.cache.clear();
        this.cacheQuery = new QueryFactory(this.cache, this.qh).getQuery(this.luceneQuery);
        assert (this.cacheQuery.getResultSize() == 0);
    }
}

