/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.LinkedList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheManager;
import org.infinispan.query.backend.QueryHelper;
import org.infinispan.query.test.Person;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class QueryHelperTest {
    Configuration cfg;
    List<CacheManager> cacheManagers;

    @BeforeMethod
    public void setUp() {
        this.cfg = new Configuration();
        this.cfg.setIndexingEnabled(true);
        this.cfg.setIndexLocalOnly(true);
        this.cacheManagers = new LinkedList<CacheManager>();
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cacheManagers);
    }

    private Cache<?, ?> createCache(Configuration c) {
        CacheManager cm = TestCacheManagerFactory.createCacheManager((Configuration)c);
        this.cacheManagers.add(cm);
        return cm.getCache();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testConstructorWithNoClasses() {
        Cache<?, ?> c = this.createCache(this.cfg);
        Class[] classes = new Class[]{};
        QueryHelper qh = new QueryHelper(c, null, classes);
    }

    @Test(expectedExceptions={CacheException.class})
    public void testCheckInterceptorChainWithIndexLocalTrue() {
        Cache<?, ?> c = this.createCache(this.cfg);
        QueryHelper qh = new QueryHelper(c, null, new Class[]{Person.class});
        QueryHelper qh2 = new QueryHelper(c, null, new Class[]{Person.class});
    }

    @Test(expectedExceptions={CacheException.class})
    public void testCheckInterceptorChainWithIndexLocalFalse() {
        this.cfg.setIndexLocalOnly(false);
        Cache<?, ?> c = this.createCache(this.cfg);
        QueryHelper qh = new QueryHelper(c, null, new Class[]{Person.class});
        QueryHelper qh2 = new QueryHelper(c, null, new Class[]{Person.class});
    }

    public void testTwoQueryHelpersWithTwoCaches() {
        Cache<?, ?> c1 = this.createCache(this.cfg);
        Cache<?, ?> c2 = this.createCache(this.cfg);
        QueryHelper qh1 = new QueryHelper(c1, null, new Class[]{Person.class});
        QueryHelper qh2 = new QueryHelper(c2, null, new Class[]{Person.class});
    }
}

