/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.QueryFactory;
import org.infinispan.query.backend.QueryHelper;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ClusteredCacheTest
extends MultipleCacheManagersTest {
    Cache<String, Person> cache1;
    Cache<String, Person> cache2;
    Person person1;
    Person person2;
    Person person3;
    Person person4;
    QueryParser queryParser;
    Query luceneQuery;
    CacheQuery cacheQuery;
    QueryHelper qh;
    List found;
    String key1 = "Navin";
    String key2 = "BigGoat";
    String key3 = "MiniGoat";
    private static final Log log = LogFactory.getLog(Person.class);

    public ClusteredCacheTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected void enhanceConfig(Configuration c) {
    }

    protected void createCacheManagers() throws Throwable {
        Configuration cacheCfg = ClusteredCacheTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.REPL_SYNC);
        this.enhanceConfig(cacheCfg);
        cacheCfg.setIndexingEnabled(true);
        cacheCfg.setIndexLocalOnly(false);
        List caches = this.createClusteredCaches(2, "infinispan-query", cacheCfg);
        this.cache1 = (Cache)caches.get(0);
        this.cache2 = (Cache)caches.get(1);
    }

    @BeforeMethod
    public void setUp() {
        this.qh = TestQueryHelperFactory.createTestQueryHelperInstance(this.cache2, Person.class);
        TestingUtil.blockUntilViewsReceived((long)60000L, (Cache[])new Cache[]{this.cache1, this.cache2});
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setBlurb("Likes playing WoW");
        this.person2 = new Person();
        this.person2.setName("BigGoat");
        this.person2.setBlurb("Eats grass");
        this.person3 = new Person();
        this.person3.setName("MiniGoat");
        this.person3.setBlurb("Eats cheese");
        this.cache1.put((Object)this.key1, (Object)this.person1);
        this.cache1.put((Object)this.key2, (Object)this.person2);
        this.cache1.put((Object)this.key3, (Object)this.person3);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache1 != null) {
            this.cache1.stop();
        }
        if (this.cache2 != null) {
            this.cache2.stop();
        }
    }

    public void testSimple() throws ParseException {
        this.cacheQuery = new QueryFactory(this.cache2, this.qh).getBasicQuery("blurb", "playing");
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1);
        if (this.found.get(0) == null) {
            log.warn((Object)"found.get(0) is null");
            Person p1 = (Person)this.cache2.get((Object)this.key1);
            if (p1 == null) {
                log.warn((Object)"Person p1 is null in sc2 and cannot actually see the data of person1 in sc1");
            } else {
                log.trace((Object)("p1 name is  " + p1.getName()));
            }
        }
        assert (this.found.get(0).equals(this.person1));
    }

    private void assertQueryInterceptorPresent(Cache<?, ?> c) {
        CommandInterceptor i = TestingUtil.findInterceptor(c, QueryInterceptor.class);
        assert (i != null) : "Expected to find a QueryInterceptor, only found " + c.getAdvancedCache().getInterceptorChain();
    }

    public void testModified() throws ParseException {
        this.assertQueryInterceptorPresent(this.cache2);
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = new QueryFactory(this.cache2, this.qh).getQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1) : "Expected list of size 1, was of size " + this.found.size();
        assert (this.found.get(0).equals(this.person1));
        this.person1.setBlurb("Likes pizza");
        this.cache1.put((Object)"Navin", (Object)this.person1);
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("pizza");
        this.cacheQuery = new QueryFactory(this.cache2, this.qh).getQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1);
        assert (this.found.get(0).equals(this.person1));
    }

    public void testAdded() throws ParseException {
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = new QueryFactory(this.cache2, this.qh).getQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 2) : "Size of list should be 2";
        assert (this.found.contains(this.person2));
        assert (this.found.contains(this.person3));
        assert (!this.found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.cache1.put((Object)"mighty", (Object)this.person4);
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = new QueryFactory(this.cache2, this.qh).getQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 3) : "Size of list should be 3";
        assert (this.found.contains(this.person2));
        assert (this.found.contains(this.person3));
        assert (this.found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testRemoved() throws ParseException {
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = new QueryFactory(this.cache2, this.qh).getQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 2);
        assert (this.found.contains(this.person2));
        assert (this.found.contains(this.person3)) : "This should still contain object person3";
        this.cache1.remove((Object)this.key3);
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = new QueryFactory(this.cache2, this.qh).getQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
    }

    public void testGetResultSize() throws ParseException {
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = new QueryFactory(this.cache2, this.qh).getQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        assert (this.found.size() == 1);
    }

    public void testClear() throws ParseException {
        this.queryParser = new QueryParser("blurb", (Analyzer)new StandardAnalyzer());
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = new QueryFactory(this.cache1, this.qh).getQuery(this.luceneQuery, new Class[0]);
        this.found = this.cacheQuery.list();
        this.luceneQuery = this.queryParser.parse("playing");
        Query[] queries = new Query[]{this.luceneQuery, this.luceneQuery};
        this.luceneQuery = this.luceneQuery.combine(queries);
        this.cacheQuery = new QueryFactory(this.cache1, this.qh).getQuery(this.luceneQuery, new Class[0]);
        assert (this.cacheQuery.getResultSize() == 3);
        this.cacheQuery = new QueryFactory(this.cache2, this.qh).getQuery(this.luceneQuery, new Class[0]);
        assert (this.cacheQuery.getResultSize() == 3);
        this.cache1.clear();
        this.cacheQuery = new QueryFactory(this.cache1, this.qh).getQuery(this.luceneQuery, new Class[0]);
        assert (this.cacheQuery.getResultSize() == 0);
        this.cacheQuery = new QueryFactory(this.cache2, this.qh).getQuery(this.luceneQuery, new Class[0]);
        assert (this.cacheQuery.getResultSize() == 0);
    }
}

