/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.util.Properties;
import org.infinispan.config.Configuration;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.backend.QueryHelper;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.config.CacheModeTest")
public class CacheModeTest
extends AbstractInfinispanTest {
    public void testLocal() {
        this.doTest(Configuration.CacheMode.LOCAL);
    }

    public void testReplicated() {
        this.doTest(Configuration.CacheMode.REPL_SYNC);
    }

    public void testInvalidated() {
        this.doTest(Configuration.CacheMode.INVALIDATION_SYNC);
    }

    public void testDistributed() {
        this.doTest(Configuration.CacheMode.DIST_SYNC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(Configuration.CacheMode m) {
        EmbeddedCacheManager cc = null;
        try {
            cc = TestCacheManagerFactory.createCacheManager((Configuration.CacheMode)m, (boolean)true);
            QueryHelper qh = new QueryHelper(cc.getCache(), new Properties(), new Class[]{Person.class});
            boolean found = false;
            for (CommandInterceptor i : cc.getCache().getAdvancedCache().getInterceptorChain()) {
                System.out.println("  Testing " + i.getClass().getSimpleName());
                if (!(i instanceof QueryInterceptor)) continue;
                found = true;
            }
            assert (found) : "Didn't find a query interceptor in the chain!!";
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cc});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cc});
    }
}

