/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.TransactionalEventTransactionContext;

public class QueryInterceptor
extends CommandInterceptor {
    protected SearchFactoryImplementor searchFactory;
    protected TransactionManager transactionManager;

    @Inject
    public void init(SearchFactoryImplementor searchFactory, TransactionManager transactionManager) {
        this.searchFactory = searchFactory;
        this.transactionManager = transactionManager;
    }

    protected boolean shouldModifyIndexes(InvocationContext ctx) {
        return true;
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object toReturn = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (this.shouldModifyIndexes(ctx)) {
            Object key = command.getKey();
            Object value = command.getValue();
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry.isCreated()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Entry is created");
                }
                this.addToIndexes(this.extractValue(value), this.extractValue(key));
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Entry is changed");
                }
                this.updateIndexes(this.extractValue(value), this.extractValue(key));
            }
        }
        return toReturn;
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object valueRemoved = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (command.isSuccessful() && !command.isNonExistent() && this.shouldModifyIndexes(ctx)) {
            this.removeFromIndexes(this.extractValue(valueRemoved), this.extractValue(command.getKey()));
        }
        return valueRemoved;
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object valueReplaced = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (valueReplaced != null && this.shouldModifyIndexes(ctx)) {
            Object[] parameters = command.getParameters();
            Object key = this.extractValue(command.getKey());
            this.removeFromIndexes(this.extractValue(parameters[1]), key);
            this.addToIndexes(this.extractValue(parameters[2]), key);
        }
        return valueReplaced;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object mapPut = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (this.shouldModifyIndexes(ctx)) {
            Map dataMap = command.getMap();
            for (Map.Entry entry : dataMap.entrySet()) {
                this.addToIndexes(this.extractValue(entry.getValue()), this.extractValue(entry.getKey()));
            }
        }
        return mapPut;
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (this.shouldModifyIndexes(ctx)) {
            if (this.trace) {
                this.log.trace((Object)"shouldModifyIndexes() is true and we can clear the indexes");
            }
            Set classes = this.searchFactory.getDocumentBuildersIndexedEntities().keySet();
            for (Class c : classes) {
                Serializable id = null;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Clearing indexes for class: - " + c));
                }
                this.searchFactory.getWorker().performWork(new Work(c, id, WorkType.PURGE_ALL), (TransactionContext)new TransactionalEventTransactionContext(this.transactionManager));
            }
        }
        return returnValue;
    }

    protected void addToIndexes(Object value, Object key) {
        if (this.trace) {
            this.log.trace((Object)"Adding to indexes for key [{0}] and value [{0}]", new Object[]{key, value});
        }
        if (value == null) {
            throw new NullPointerException("Cannot handle a null value!");
        }
        TransactionalEventTransactionContext transactionContext = new TransactionalEventTransactionContext(this.transactionManager);
        this.searchFactory.getWorker().performWork(new Work(value, (Serializable)((Object)KeyTransformationHandler.keyToString(key)), WorkType.ADD), (TransactionContext)transactionContext);
    }

    protected void removeFromIndexes(Object value, Object key) {
        if (value == null) {
            throw new NullPointerException("Cannot handle a null value!");
        }
        TransactionalEventTransactionContext transactionContext = new TransactionalEventTransactionContext(this.transactionManager);
        this.searchFactory.getWorker().performWork(new Work(value, (Serializable)((Object)KeyTransformationHandler.keyToString(key)), WorkType.DELETE), (TransactionContext)transactionContext);
    }

    protected void updateIndexes(Object value, Object key) {
        if (value == null) {
            throw new NullPointerException("Cannot handle a null value!");
        }
        TransactionalEventTransactionContext transactionContext = new TransactionalEventTransactionContext(this.transactionManager);
        this.searchFactory.getWorker().performWork(new Work(value, (Serializable)((Object)KeyTransformationHandler.keyToString(key)), WorkType.UPDATE), (TransactionContext)transactionContext);
    }

    private Object extractValue(Object wrappedValue) {
        if (wrappedValue instanceof MarshalledValue) {
            return ((MarshalledValue)wrappedValue).get();
        }
        return wrappedValue;
    }
}

