/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.QueryFactory;
import org.infinispan.query.backend.QueryHelper;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.CustomKey;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class KeyTypeTest
extends SingleCacheManagerTest {
    Cache<Object, Person> cache;
    QueryHelper qh;
    Person person1;

    public KeyTypeTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration c = KeyTypeTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.LOCAL, (boolean)true);
        c.setIndexingEnabled(true);
        c.setIndexLocalOnly(false);
        this.cacheManager = TestCacheManagerFactory.createCacheManager((Configuration)c, (boolean)true);
        this.cache = this.cacheManager.getCache();
        this.qh = TestQueryHelperFactory.createTestQueryHelperInstance(this.cache, Person.class);
        this.person1 = new Person();
        this.person1.setName("Navin");
        this.person1.setBlurb("Owns a macbook");
        this.person1.setAge(20);
        return this.cacheManager;
    }

    public void testPrimitiveAndStringKeys() {
        String key1 = "key1";
        int key2 = 2;
        byte key3 = 3;
        float key4 = 4.0f;
        long key5 = 5L;
        short key6 = 6;
        boolean key7 = true;
        double key8 = 8.0;
        char key9 = '9';
        this.cache.put((Object)key1, (Object)this.person1);
        this.cache.put((Object)key2, (Object)this.person1);
        this.cache.put((Object)key3, (Object)this.person1);
        this.cache.put((Object)Float.valueOf(key4), (Object)this.person1);
        this.cache.put((Object)key5, (Object)this.person1);
        this.cache.put((Object)key6, (Object)this.person1);
        this.cache.put((Object)key7, (Object)this.person1);
        this.cache.put((Object)key8, (Object)this.person1);
        this.cache.put((Object)Character.valueOf(key9), (Object)this.person1);
        Term term = new Term("blurb", "owns");
        CacheQuery cacheQuery = new QueryFactory(this.cache, this.qh).getQuery((Query)new TermQuery(term), new Class[0]);
        assert (cacheQuery.getResultSize() == 9);
        List found = cacheQuery.list();
        for (int i = 0; i < 9; ++i) {
            assert (found.get(i).equals(this.person1));
        }
    }

    public void testCustomKeys() {
        int i;
        CustomKey key1 = new CustomKey(1, 2, 3);
        CustomKey key2 = new CustomKey(900, 800, 700);
        CustomKey key3 = new CustomKey(1024, 2048, 4096);
        this.cache.put((Object)key1, (Object)this.person1);
        this.cache.put((Object)key2, (Object)this.person1);
        this.cache.put((Object)key3, (Object)this.person1);
        Term term = new Term("blurb", "owns");
        CacheQuery cacheQuery = new QueryFactory(this.cache, this.qh).getQuery((Query)new TermQuery(term), new Class[0]);
        assert ((i = cacheQuery.getResultSize()) == 3) : "Expected 3, was " + i;
    }
}

