/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.impl.SearchFactoryImpl;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.backend.QueryHelper;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(testName="query.blackbox.SearchFactoryShutdownTest", groups={"functional"})
public class SearchFactoryShutdownTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCorrectShutdown() throws NoSuchFieldException, IllegalAccessException {
        EmbeddedCacheManager cc = null;
        try {
            Configuration c = SingleCacheManagerTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.LOCAL, (boolean)true);
            c.setIndexingEnabled(true);
            c.setIndexLocalOnly(false);
            cc = TestCacheManagerFactory.createCacheManager((Configuration)c, (boolean)true);
            Cache cache = cc.getCache();
            QueryHelper qh = TestQueryHelperFactory.createTestQueryHelperInstance(cache, Person.class, AnotherGrassEater.class);
            SearchFactoryImpl sfi = (SearchFactoryImpl)TestingUtil.extractComponent((Cache)cache, SearchFactoryImplementor.class);
            assert (!this.isStopped(sfi));
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cc});
            assert (this.isStopped(sfi));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cc});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cc});
    }

    private boolean isStopped(SearchFactoryImpl sfi) {
        try {
            Field status = SearchFactoryImpl.class.getDeclaredField("stopped");
            status.setAccessible(true);
            AtomicBoolean b = (AtomicBoolean)status.get(sfi);
            return b.get();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot test running state of the search factory", e);
        }
    }
}

