/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.InfinispanConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="config.parsing.QueryParsingTest")
public class QueryParsingTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryConfig() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:4.2 http://www.infinispan.org/schemas/infinispan-config-4.2.xsd\"\n      xmlns=\"urn:infinispan:config:4.2\">   <global>\n      <transport clusterName=\"demoCluster\"/>\n   </global>\n\n   <default>\n      <clustering mode=\"replication\">\n      </clustering>\n      <indexing enabled=\"true\" indexLocalOnly=\"true\"/>\n   </default>\n</infinispan>";
        System.out.println(config);
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        InputStream schema = InfinispanConfiguration.findSchemaInputStream();
        assert (schema != null);
        InfinispanConfiguration c = InfinispanConfiguration.newInfinispanConfiguration((InputStream)is, (InputStream)schema);
        GlobalConfiguration gc = c.parseGlobalConfiguration();
        assert (gc.getTransportClass().equals(JGroupsTransport.class.getName()));
        assert (gc.getClusterName().equals("demoCluster"));
        Configuration def = c.parseDefaultConfiguration();
        assert (def.isIndexingEnabled());
        assert (def.isIndexLocalOnly());
        Configuration dolly = def.clone();
        assert (dolly.isIndexingEnabled());
        assert (dolly.isIndexLocalOnly());
        Configuration other = new Configuration();
        other.setUseLazyDeserialization(true);
        other.setUseLockStriping(false);
        other.applyOverrides(dolly);
        assert (other.isUseLazyDeserialization());
        assert (!other.isUseLockStriping());
        assert (other.isIndexingEnabled());
        assert (other.isIndexLocalOnly());
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((Configuration)def);
        try {
            Cache cache = cm.getCache("test");
            cache.stop();
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
    }
}

