/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.infinispan.Cache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.backend.QueryHelper;
import org.infinispan.query.impl.CacheQueryImpl;

public class QueryFactory {
    private final Cache cache;
    private final SearchFactoryImplementor searchFactory;

    public QueryFactory(Cache cache, QueryHelper qh) {
        this.cache = cache;
        this.searchFactory = qh.getSearchFactory();
    }

    public CacheQuery getQuery(Query luceneQuery, Class<?> ... classes) {
        return new CacheQueryImpl(luceneQuery, this.searchFactory, this.cache, classes);
    }

    public CacheQuery getBasicQuery(String field, String search, Version luceneVersion) throws ParseException {
        QueryParser parser = new QueryParser(luceneVersion, field, (Analyzer)new StandardAnalyzer(luceneVersion));
        Query luceneQuery = parser.parse(search);
        return new CacheQueryImpl(luceneQuery, this.searchFactory, this.cache, new Class[0]);
    }

    @Deprecated
    public CacheQuery getBasicQuery(String field, String search) throws ParseException {
        return this.getBasicQuery(field, search, Version.LUCENE_CURRENT);
    }
}

