/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.InfinispanConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="config.parsing.QueryParsingTest")
public class QueryParsingTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryConfig() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.0 http://www.infinispan.org/schemas/infinispan-config-5.0.xsd\"\n      xmlns=\"urn:infinispan:config:5.0\">\n   <global>\n      <transport clusterName=\"demoCluster\" />\n   </global>\n   <default>\n      <clustering mode=\"replication\" />\n      <indexing enabled=\"true\" indexLocalOnly=\"true\" />\n   </default>\n</infinispan>";
        System.out.println("Using test configuration:\n\n" + config + "\n");
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        InputStream schema = InfinispanConfiguration.findSchemaInputStream();
        assert (schema != null);
        InfinispanConfiguration c = InfinispanConfiguration.newInfinispanConfiguration((InputStream)is, (InputStream)schema);
        GlobalConfiguration gc = c.parseGlobalConfiguration();
        assert (gc.getTransportClass().equals(JGroupsTransport.class.getName()));
        assert (gc.getClusterName().equals("demoCluster"));
        Configuration def = c.parseDefaultConfiguration();
        assert (def.isIndexingEnabled());
        assert (def.isIndexLocalOnly());
        Configuration dolly = def.clone();
        assert (dolly.isIndexingEnabled());
        assert (dolly.isIndexLocalOnly());
        Configuration other = new Configuration().fluent().lazyDeserialization().locking().useLockStriping(Boolean.valueOf(false)).build();
        other.applyOverrides(dolly);
        assert (other.isUseLazyDeserialization());
        assert (!other.isUseLockStriping());
        assert (other.isIndexingEnabled());
        assert (other.isIndexLocalOnly());
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((Configuration)def);
        try {
            Cache cache = cm.getCache("test");
            cache.stop();
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
    }
}

