/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexedembedded;

import java.util.List;
import junit.framework.Assert;
import org.apache.lucene.queryParser.ParseException;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.QueryFactory;
import org.infinispan.query.indexedembedded.City;
import org.infinispan.query.indexedembedded.Country;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CollectionsIndexingTest
extends SingleCacheManagerTest {
    private QueryFactory qf;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration c = this.getDefaultStandaloneConfig(true);
        c.fluent().indexing().indexLocalOnly(Boolean.valueOf(false)).addProperty("hibernate.search.default.directory_provider", "ram");
        return TestCacheManagerFactory.createCacheManager((Configuration)c, (boolean)true);
    }

    @BeforeClass
    public void prepareSearchFactory() throws Exception {
        this.qf = new QueryFactory(this.cache);
    }

    @AfterMethod
    public void cleanupData() {
        this.cache.clear();
    }

    @Test
    public void searchOnEmptyIndex() throws ParseException {
        List list = this.qf.getBasicQuery("countryName", "Italy", new Class[]{Country.class, City.class}).list();
        Assert.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void searchOnSimpleField() throws ParseException {
        Country italy = new Country();
        italy.countryName = "Italy";
        this.cache.put((Object)"IT", (Object)italy);
        List list = this.qf.getBasicQuery("countryName", "Italy", new Class[]{Country.class, City.class}).list();
        Assert.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void searchOnEmbeddedField() throws ParseException {
        Country uk = new Country();
        City london = new City();
        london.name = "London";
        City newcastle = new City();
        newcastle.name = "Newcastle";
        uk.countryName = "United Kingdom";
        uk.cities.add(newcastle);
        uk.cities.add(london);
        this.cache.put((Object)"UK", (Object)uk);
        List list = this.qf.getBasicQuery("cities.name", "Newcastle", new Class[]{Country.class, City.class}).list();
        Assert.assertEquals((int)1, (int)list.size());
        Assert.assertTrue((uk == list.get(0) ? 1 : 0) != 0);
    }
}

